#include <STRING.H>
#include <FCNTL.H>
#include <SYS/STAT.H>
#include <SPAD/DEV.H>
#include <SPAD/LIBC.H>

#include <STDLIB.H>
#include <SYS/PARAM.H>

char *canonicalize_file_name(const char *path)
{
	return realpath(path, NULL);
}

char *realpath(const char *path, char resolved[PATH_MAX])
{
	static struct stat dummy;
	char c;
	unsigned flags;
	char *p, *sl, *ret;
	int h;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ZERO)))
		KERNEL$SUICIDE("realpath AT SPL %08X", KERNEL$SPL);
#endif
	if (__unlikely(!path)) {
		errno = EINVAL;
		return NULL;
	}
	if (__unlikely(!*path)) path = ".";
	h = open(path, _O_NOACCESS | _O_NOPOSIX | _O_NOOPEN);
	if (__unlikely(h < 0)) {
		err0:
		if (__likely(resolved != NULL))
			strlcpy(resolved, path, PATH_MAX);
		return NULL;
	}
	p = KERNEL$HANDLE_PATH(h);
	if (__likely(resolved != NULL)) {
		if (__unlikely(strlen(p) >= PATH_MAX)) {
			errno = ENAMETOOLONG;
			close_err0:
			KERNEL$FAST_CLOSE(h);
			goto err0;
		}
		strcpy(resolved, p);
		flags = 0;
	} else {
		resolved = strdup(p);
		if (__unlikely(!resolved))
			goto close_err0;
		flags = 2;
	}
	KERNEL$FAST_CLOSE(h);
	ret = resolved;
	eat_next_element:
	sl = strrchr(resolved, '/');
	if (__unlikely(!sl))
		KERNEL$SUICIDE("realpath: PATH DOESN'T CONTAIN SLASH: \"%s\"", resolved);
	if (__unlikely(strchr(resolved, '/') == sl)) sl++;
	c = *sl;
	*sl = 0;
	if (__likely(!stat(resolved, &dummy))) {
		*sl = c;
		goto return_ret;
	}
	flags |= 1;
	if (__likely(c == '/')) goto eat_next_element;
	return_ret:
	if (__unlikely(flags & 1)) {
		if (__unlikely(flags & 2))
			free(resolved);
		return NULL;
	}
	return resolved;
}

