#include <SPAD/SYSLOG.H>

#include <SYSLOG.H>

extern const char *__progname;
static const char *logname = NULL;

void syslog(int pri, const char *fmt, ...)
{
	va_list ap;
	va_start(ap, fmt);
	vsyslog(pri, fmt, ap);
	va_end(ap);
}

void vsyslog(int pri, const char *fmt, va_list ap)
{
	KERNEL$SYSLOGV(pri == LOG_EMERG || pri == LOG_ALERT || pri == LOG_CRIT || pri == LOG_ERR ? __SYSLOG_SW_ERROR : pri == LOG_WARNING ? __SYSLOG_SW_WARNING : __SYSLOG_SW_INFO, !logname ? __progname : logname, fmt, ap);
}

void openlog(const char *name, int option, int facility)
{
	logname = name;
}

void closelog(void)
{
}

int setlogmask(int mask)
{
	return 0;
}
