#ifndef __LIB_LIBC_SPINLOCK_H
#define __LIB_LIBC_SPINLOCK_H

#include <SYS/TYPES.H>
#include <ARCH/BITOPS.H>
#include <ARCH/BARRIER.H>
#include <SPAD/SYNC.H>

typedef struct {
	int access_lock;
} spinlock_t;

#define	_SPINLOCK_INITIALIZER	{ 0 }

#define _SPINUNLOCK(_lck)						\
do {									\
	__barrier();							\
	(_lck)->access_lock = 0;					\
} while (0)

#define	_SPINLOCK(_lck)							\
do {									\
	while (__unlikely(__CMPXCHGI(&(_lck)->access_lock, 0, 1) != 0))	\
		KERNEL$THREAD_YIELD();					\
} while (0)

#endif /* _SPINLOCK_H_ */
