#include <STDIO.H>
#include <STDLIB.H>
#include <SPAD/WQ.H>
#include <SPAD/THREAD.H>
#include <SPAD/LIBC.H>
#include <ARCH/SETUP.H>
#include "LIBC_PRIVATE.H"
#include "STDIO_INTERNAL.H"

typedef struct {
	MTX mtx;
	THREAD_RQ *holder;
	int count;
} LOCK;

#define INIT_LOCK(ret)							\
do {									\
	if (__unlikely(!fp->_mtx)) {					\
		lock = malloc(sizeof(LOCK));				\
		if (__unlikely(!lock)) ret;				\
		MTX_INIT(&lock->mtx, "LIBC$FILE_MTX");			\
		lock->holder = NULL;					\
		if (__unlikely(__CMPXCHGL((long *)&fp->_mtx, 0, (unsigned long)lock))) free(lock);							\
	}								\
} while (0)

void flockfile(FILE *fp)
{
	LOCK *lock;
	THREAD_RQ *me;
	if (__unlikely(fp->_file == -1)) return;
	INIT_LOCK(return);
	me = KERNEL$THREAD_RQ();
	lock = (LOCK *)fp->_mtx;
	if (__unlikely(lock->holder == me)) {
		lock->count++;
		return;
	}
	MTX_LOCK_SYNC(&lock->mtx);
	lock->count = 1;
	lock->holder = me;
}

int ftrylockfile(FILE *fp)
{
	LOCK *lock;
	THREAD_RQ *me;
	if (__unlikely(fp->_file == -1)) return 0;
	INIT_LOCK(return 0);
	me = KERNEL$THREAD_RQ();
	lock = (LOCK *)fp->_mtx;
	if (__unlikely(lock->holder == me)) {
		lock->count++;
		return 0;
	}
	if (__unlikely(MTX_TRY_LOCK(&lock->mtx))) return -1;
	lock->count = 1;
	lock->holder = me;
	return 0;
}

void funlockfile(FILE *fp)
{
	LOCK *lock;
	if (__unlikely(fp->_file == -1)) return;
	lock = (LOCK *)fp->_mtx;
#if __DEBUG >= 1
	if (__unlikely(lock->holder != KERNEL$THREAD_RQ()))
		KERNEL$SUICIDE("funlockfile: unlocking other's lock");
	if (__unlikely(!lock->count))
		KERNEL$SUICIDE("funlockfile: zero count");
#endif
	if (__unlikely(--lock->count)) return;
	lock->holder = NULL;
	MTX_UNLOCK(&lock->mtx);
}
