#include "STDIO_INTERNAL.H"

int feof_unlocked(FILE *f)
{
	return __sfeof(f);
}

int ferror_unlocked(FILE *f)
{
	return __sferror(f);
}

void clearerr_unlocked(FILE *f)
{
	__sclearerr(f);
}

int fileno_unlocked(FILE *f)
{
	return __sfileno(f);
}

int getc_unlocked(FILE *f)
{
	return __sgetc(f);
}

int putc_unlocked(int x, FILE *f)
{
	return __sputc(x, f);
}

int getc(FILE *f)
{
	return __getc_locked(f);
}

int putc(int x, FILE *f)
{
	return __putc_locked(x, f);
}

int getchar(void)
{
	return getc(stdin);
}

int getchar_unlocked(void)
{
	return getc_unlocked(stdin);
}

int putchar(int x)
{
	return putc(x, stdout);
}

int putchar_unlocked(int x)
{
	return putc_unlocked(x, stdout);
}

FILE *fropen(const void *cookie, int (*fn)(void *, char *, int))
{
	return funopen(cookie, fn, NULL, NULL, NULL);
}

FILE *fwopen(const void *cookie, int (*fn)(void *, const char *, int))
{
	return funopen(cookie, NULL, fn, NULL, NULL);
}

