#include <SYS/TYPES.H>
#include <STRING.H>
#include <STDLIB.H>
#include <FCNTL.H>
#include <UNISTD.H>
#include <ERRNO.H>
#include <SPAD/LIBC.H>

#include <SPAD/PCIID.H>

#define PCI_IDS_FILE	"LIB.:/PCI.IDS"

static char *get_line(int h)
{
	size_t l = 64;
	size_t p;
	ssize_t r;
	char *nl;
	char *s = __sync_malloc(l);
	if (__unlikely(!s)) return __ERR_PTR(-errno);
	new_line:
	p = 0;
	more:
	r = read(h, s + p, l - p - 1);
	if (__unlikely(r < 0)) {
		ret_errno:
		free(s);
		return __ERR_PTR(-errno);
	}
	p += r;
	if ((nl = memchr(s, '\n', p))) {
		off_t x;
		if (__unlikely((x = lseek(h, (ssize_t)(nl - s - p + 1), SEEK_CUR)) == -1)) {
			goto ret_errno;
		}
		goto got_line;
	}
	if (__unlikely(!r)) {
		nl = s + p;
		goto got_line;
	}
	if (__likely(p == l - 1)) {
		s = __sync_reallocf(s, l *= 2);
		if (__unlikely(!s)) return __ERR_PTR(-errno);
	}
	goto more;
	got_line:
	*nl = 0;
	while (__likely(nl != s) && (nl[-1] == '\r' || nl[-1] == ' ' || nl[-1] == '\t')) nl[-1] = 0, nl--;
	if (__unlikely(!s[0]) || __unlikely(s[0] == '#')) {
		if (__unlikely(!r)) {
			free(s);
			return NULL;
		}
		goto new_line;
	}
	return s;
}

static int gethex(char *str, int digits, int spaces)
{
	int num = 0;
	while (digits--) {
		char c = __upcasechr(*str++);
		if (c >= '0' && c <= '9') num = num * 16 + c - '0';
		else if (c >= 'A' && c <= 'Z') num = num * 16 + c - 'A' + 10;
		else return -1;
	}
	while (spaces--) {
		if (*str++ != ' ') return -1;
	}
	return num;
}

int PCIID$DESCRIBE_DEVICE(char *filename, __u16 vendor_id, __u16 device_id, __u16 subvendor, __u16 subdevice_id, char **vendor_str, char **device_str, char **subdevice_str)
{
	int h;
	char *l;
	if (vendor_str) *vendor_str = NULL;
	if (device_str) *device_str = NULL;
	if (subdevice_str) *subdevice_str = NULL;
	if (__likely(!filename)) filename = PCI_IDS_FILE;
	h = open(filename, O_RDONLY);
	if (__unlikely(h < 0)) return -errno;

	next_vendor:
	l = get_line(h);
	if (__unlikely(__IS_ERR(l))) goto err;
	if (__unlikely(!l)) goto finish;
	if (__likely(gethex(l, 4, 2) != vendor_id)) {
		free(l);
		goto next_vendor;
	}
	if (vendor_str) {
		memmove(l, l + 6, strlen(l + 5));
		*vendor_str = l;
	} else {
		free(l);
	}

	if (!device_str && !subdevice_str) goto finish;
	next_device:
	l = get_line(h);
	if (__unlikely(__IS_ERR(l))) goto err;
	if (__unlikely(!l)) goto finish;
	if (__unlikely(l[0] != '\t')) {
		free(l);
		goto finish;
	}
	if (gethex(l + 1, 4, 2) != device_id) {
		free(l);
		goto next_device;
	}
	if (device_str) {
		memmove(l, l + 7, strlen(l + 6));
		*device_str = l;
	} else {
		free(l);
	}

	if (!subdevice_str) goto finish;
	next_subdevice:
	l = get_line(h);
	if (__unlikely(__IS_ERR(l))) goto err;
	if (__unlikely(!l)) goto finish;
	if (__unlikely(l[0] != '\t') || __unlikely(l[1] != '\t')) {
		free(l);
		goto finish;
	}
	if (gethex(l + 2, 4, 1) != subvendor || gethex(l + 7, 4, 2) != subdevice_id) {
		free(l);
		goto next_subdevice;
	}
	memmove(l, l + 13, strlen(l + 12));
	*subdevice_str = l;

	finish:
	close(h);
	return 0;

	err:
	if (vendor_str && *vendor_str) free(*vendor_str), *vendor_str = NULL;
	if (device_str && *device_str) free(*device_str), *device_str = NULL;
	if (subdevice_str && *subdevice_str) free(*subdevice_str), *subdevice_str = NULL;
	close(h);
	return __PTR_ERR(l);
}

int PCIID$DESCRIBE_CLASS(char *filename, __u8 class_device_id, __u8 class_device_sub_id, __u8 class_prog_id, char **class_device_str, char **class_device_sub_str, char **class_prog_str)
{
	int h;
	char *l;
	if (class_device_str) *class_device_str = NULL;
	if (class_device_sub_str) *class_device_sub_str = NULL;
	if (class_prog_str) *class_prog_str = NULL;
	if (__likely(!filename)) filename = PCI_IDS_FILE;
	h = open(filename, O_RDONLY);
	if (__unlikely(h < 0)) return -errno;

	next_class:
	l = get_line(h);
	if (__unlikely(__IS_ERR(l))) goto err;
	if (__unlikely(!l)) goto finish;
	if (__likely(l[0] != 'C') || l[1] != ' ' || gethex(l + 2, 2, 2) != class_device_id) {
		free(l);
		goto next_class;
	}
	if (class_device_str) {
		memmove(l, l + 6, strlen(l + 5));
		*class_device_str = l;
	} else {
		free(l);
	}

	if (!class_device_sub_str && !class_prog_str) goto finish;
	next_subclass:
	l = get_line(h);
	if (__unlikely(__IS_ERR(l))) goto err;
	if (__unlikely(!l)) goto finish;
	if (__unlikely(l[0] != '\t')) {
		free(l);
		goto finish;
	}
	if (gethex(l + 1, 2, 2) != class_device_sub_id) {
		free(l);
		goto next_subclass;
	}
	if (class_device_sub_str) {
		memmove(l, l + 5, strlen(l + 4));
		*class_device_sub_str = l;
	} else {
		free(l);
	}

	if (!class_prog_str) goto finish;
	next_prog:
	l = get_line(h);
	if (__unlikely(__IS_ERR(l))) goto err;
	if (__unlikely(!l)) goto finish;
	if (__unlikely(l[0] != '\t') || __unlikely(l[1] != '\t')) {
		free(l);
		goto finish;
	}
	if (gethex(l + 2, 2, 2) != class_prog_id) {
		free(l);
		goto next_prog;
	}
	memmove(l, l + 6, strlen(l + 5));
	*class_prog_str = l;

	finish:
	close(h);
	return 0;

	err:
	if (class_device_str && *class_device_str) free(*class_device_str), *class_device_str = NULL;
	if (class_device_sub_str && *class_device_sub_str) free(*class_device_sub_str), *class_device_sub_str = NULL;
	if (class_prog_str && *class_prog_str) free(*class_prog_str), *class_prog_str = NULL;
	close(h);
	return __PTR_ERR(l);
}
