#include <SIGNAL.H>

#include <PTHREAD.H>
#include "PTHREAD.H"

int pthread_sigmask(int __how, const sigset_t *__set, sigset_t *__oldset)
{
	return sigprocmask(__how, __set, __oldset);
}

static void do_raise(void *s, unsigned sig)
{
	LOWER_SPL(SPL_ZERO);
	if (__unlikely(sig == SIGKILL)) pthread_exit(PTHREAD_CANCELED);
	else if (__unlikely(sig == SIGSTOP)) {
		sigset_t s;
		sigemptyset(&s);
		sigaddset(&s, SIGCONT);
		_thread_sigwait(&s);
	}
	else _thread_raise(sig);
	RAISE_SPL(SPL_BOTTOM);
}

int pthread_kill(pthread_t thread, int sig)
{
	KERNEL$CALL_IN_THREAD(&thread->rq, do_raise, NULL, sig);
	return 0;
}

