#include <SPAD/LIBC.H>
#include <SPAD/TIMER.H>
#include <ARCH/BITOPS.H>
#include <ARCH/BARRIER.H>

#include <PTHREAD.H>
#include "PTHREAD.H"

#define PTHREAD_ONCE_DONE		1

static void pthread_once_cancel(void *once_);

int pthread_once(pthread_once_t *once, void (*fn)(void))
{
	long onc;
	pthread_t p;
	again:
	onc = *once;
	if (__likely(onc == PTHREAD_ONCE_DONE)) return 0;
	if (__unlikely(onc != PTHREAD_ONCE_INIT)) {
		pth_sleep();
		goto again;
	}
	pthread_cleanup_push(pthread_once_cancel, once);
	p = pthread_self();
	if (__unlikely(__CMPXCHGL(once, PTHREAD_ONCE_INIT, (long)p) != 0)) {
		pthread_cleanup_pop(0);
		__barrier();
		goto again;
	}
	fn();
	__CMPXCHGL(once, (long)p, PTHREAD_ONCE_DONE);
	pthread_cleanup_pop(0);
	return 0;
}

static void pthread_once_cancel(void *once_)
{
	long *once = once_;
	pthread_t p = pthread_self();
	__CMPXCHGL(once, (long)p, PTHREAD_ONCE_INIT);
}
