#include <TIME.H>
#include <SYS/TIME.H>
#include <SPAD/TIMER.H>

#include "PTHREAD.H"

int time_after(const struct timespec *ts)
{
	struct timeval tv;
	if (__unlikely(gettimeofday(&tv, NULL))) return 1;
	if (__unlikely(tv.tv_sec < ts->tv_sec)) return 0;
	if (__unlikely(tv.tv_sec > ts->tv_sec)) return 1;
	return __unlikely(tv.tv_usec * 1000 >= ts->tv_nsec);
}

void set_timer(TIMER *tm, const struct timespec *ts)
{
	u_jiffies_t j;
	if (__unlikely((u_jiffies_t)ts->tv_sec >= (u_jiffies_t)-1 / JIFFIES_PER_SECOND / 2)) {
		if (ts->tv_sec < 0) {
			KERNEL$SET_TIMER(0, tm);
		} else {
			SET_TIMER_NEVER(tm);
		}
		return;
	}
	j = (u_jiffies_t)ts->tv_sec * JIFFIES_PER_SECOND + (unsigned)ts->tv_nsec / (1000000000 / JIFFIES_PER_SECOND);
	KERNEL$SET_TIMER(j - KERNEL$GET_JIFFIES(), tm);
}

