#ifndef __SHELL_SHELL_H
#define __SHELL_SHELL_H

#include "SHELLCTX.H"

/* SHELL.C */

#define GLOBCHAR(c)	(__unlikely((c) == '*') || __unlikely((c) == '?') || __unlikely((c) == '[') || __unlikely((c) == '~'))

struct var {
	LIST_ENTRY hash;
	XLIST_HEAD for_values;
	const char *for_ptr;
	__s64 for_to;
	__s64 for_step;
	int namel;
	char name[1];
};

struct for_value {
	LIST_ENTRY list;
	char value[1];
};

#define var_reusable(v)		(!(v)->for_ptr)

struct var *find_var(CTX *ctx, const char *n, const char *e, int only_this);
char *find_var_name(CTX *ctx, const char **pp, const char *e, int sync, int *fr);
void del_var(struct var *v);
void free_var(struct var *v);
void init_var(struct var *v);
void add_var(CTX *ctx, struct var *v);
int check_var_name(const char *name, const char *nameend);
const char *find_var_env(CTX *ctx, const char *e);

static __finline__ int is_var_char(char c)
{
	return (c >= '0' && c <= '9') || (c >= 'A' && c <= 'Z') || (c >= 'a' && c <= 'z') || c == '@' || c == '$' || c == '_';
}

const char *FIND_LABEL(int brk, const char *start, const char *end, const char *label);
const char *FIND_COMMAND(int brk, const char *start, const char *end, const char *cmd, const char *arg);
const char *NEXT_LINE(const char *start, const char *pos, const char *end, int line);

void *liblink(CTX *ctx, char *dll, ...);
void libclose(void *lib);

void set_color(CTX *ctx, shell_color_t attr, shell_color_t mask, char *string);

/* SHELLCMD.C */

extern AST_STUB SHELL_CALL_COMMAND;
CMD *FIND_CMD(const char *name);

/* SHELLDIR.C */

void SHELL_DIR_COMMAND(CTX *ctx);

/* SHELLLN.C */

void SHELL_ASSIGN_COMMAND(CTX *ctx);
void SHELL_DEASSIGN_COMMAND(CTX *ctx);
void SHELL_SETLOGICAL_COMMAND(CTX *ctx);

/* SHELLJOB.C */

extern AST_STUB SHELL_SPAWN_COMMAND;
extern AST_STUB SHELL_FG_COMMAND;
extern AST_STUB SHELL_REMAP_COMMAND;
extern AST_STUB SHELL_JOBS_COMMAND;
extern AST_STUB SHELL_PROC_CTRL_COMMAND;

/* SHELLINT.C */

extern AST_STUB SHELL_INT_COMMAND;

/* SHELLEXP.C */

char *EVAL_EXPRESSION(CTX *ctx, const char *s, const char *e, int *fr);

/* SHELLFN.C */

char *subchr(CTX *ctx, char *str, char *pos);
char *substr(CTX *ctx, char *str, char *from, char *to);
FUNCTION *FIND_FUNCTION(const char *name);
FUNCTION *FIND_OPERATOR(const char *name);
int OPERATOR_LENGTH(const char *s, const char *e);

#endif
