#include <STDLIB.H>
#include <STRING.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>

#include "SHELL.H"

#define STK_STRING	1
#define STK_FUNC	2
#define STK_OPERATOR	3
#define STK_BRACKET	4
#define STK_COMMA	5
#define STK_SUBSTRING	6
#define STK_TO		7

typedef struct {
	int n_entries;
	char **entries;
	char *flags;
} STACK;

static void FREE_STACK(STACK *stack)
{
	int i;
	for (i = 0; i < stack->n_entries; i++) free(stack->entries[i]);
	free(stack->entries);
	free(stack->flags);
	memset(stack, 0, sizeof(STACK));
}

static int PUSH(STACK *stack, char *string, char flags)
{
	char **e;
	char *f;
	if (__unlikely(!(e = __sync_realloc(stack->entries, (stack->n_entries + 1) * sizeof(char *))))) goto nomem;
	stack->entries = e;
	if (__unlikely(!(f = __sync_realloc(stack->flags, stack->n_entries + 1)))) goto nomem;
	stack->flags = f;
	stack->entries[stack->n_entries] = string;
	stack->flags[stack->n_entries] = flags;
	stack->n_entries++;
	return 0;

	nomem:
	free(string);
	return 1;
}

static void POP(STACK *stack)
{
	if (__unlikely(!stack->n_entries)) KERNEL$SUICIDE("POP: EMPTY STACK");
	free(stack->entries[--stack->n_entries]);
}

static int GET_PRIO(char *op, char flags)
{
	FUNCTION *opf;
	switch (flags) {
		case STK_STRING:
			KERNEL$SUICIDE("GET_PRIO: STRING \"%s\"", op);
		case STK_FUNC:
			opf = FIND_FUNCTION(op);
			if (__unlikely(!opf)) KERNEL$SUICIDE("GET_PRIO: FUNCTION \"%s\"", op);
			return opf->priority;
		case STK_OPERATOR:
			opf = FIND_OPERATOR(op);
			if (__unlikely(!opf)) KERNEL$SUICIDE("GET_PRIO: OPERATOR \"%s\"", op);
			return opf->priority;
		case STK_BRACKET:
			return PRIO_BRACKET;
		case STK_COMMA:
			return PRIO_BRACKET;
		case STK_SUBSTRING:
			return PRIO_BRACKET;
		case STK_TO:
			return PRIO_BRACKET;
		default:
			KERNEL$SUICIDE("GET_PRIO: FLAGS %d, OPERATION \"%s\"", flags, op);
	}
}

static __finline__ int is_white_char(char c)
{
	return c == ' ' || __unlikely(c == 9) || __unlikely(c == 10) || __unlikely(c == 13);
}

static void NEXT_TOK(const char **p, const char *e, const char **t, int *l)
{
	const char *s = *p;
	char c;
	sw:
	if (__unlikely(s >= e)) {
		*t = NULL;
		*l = 0;
		return;
	}
	c = *s;
	if (__unlikely(is_white_char(*s))) {
		s++;
		goto sw;
	}
	*t = s;
	if (is_var_char(c) || __unlikely(c == '#')) {
		do s++; while (__likely(s < e) && __likely(is_var_char(*s)));
		*l = s - *t;
		*p = s;
		return;
	}
	if (c == '"') {
		while (1) {
			if (__unlikely(++s >= e)) break;
			c = *s;
			if (__likely(c != '"')) continue;
			if (__likely(++s < e) && __unlikely(*s == '"')) continue;
			break;
		}
		*l = s - *t;
		*p = s;
		return;
	}
	*l = OPERATOR_LENGTH(s, e);
	*p = s + *l;
	return;
}

static int EVAL_UNTIL(CTX *ctx, STACK *stack, int pri)
{
	int sp;
	char *op;
	char flags;
	char *res;
	FUNCTION *opf;
	retry:
	if (stack->n_entries < 2) return 0;
	sp = GET_PRIO(op = stack->entries[stack->n_entries - 2], flags = stack->flags[stack->n_entries - 2]);
	if (__unlikely(sp < pri)) return 0;
	if (__likely(flags == STK_OPERATOR)) {
		if (__unlikely(stack->n_entries < 3)) return 0;
		opf = FIND_OPERATOR(op);
		if (__unlikely(!opf)) KERNEL$SUICIDE("EVAL_UNTIL: UNKNOWN OPERATOR \"%s\"", op);
		if (__likely(opf->arguments != -1) && __unlikely(opf->arguments != 2)) {
			args:
			_snprintf(ctx->return_msg, __MAX_STR_LEN, "WRONG NUMBER OF ARGUMENTS TO FUNCTION IN EXPRESSION");
			ctx->return_val = -EBADSYN;
			ctx->internal_flags |= SHELL_THREAD_ERROR;
			return 1;
		}
		res = opf->function(ctx, 2, &stack->entries[stack->n_entries - 3], op);
		POP(stack);
		POP(stack);
		POP(stack);
		do_result:
		if (__unlikely(res == (void *)1)) {
			no_mem:
			_snprintf(ctx->return_msg, __MAX_STR_LEN, "OUT OF MEMORY FOR EXPRESSION");
			ctx->return_val = -ENOMEM;
			ctx->internal_flags |= SHELL_THREAD_ERROR;
			return 1;
		}
		if (__unlikely(!res)) return 1;
		if (__unlikely(PUSH(stack, res, STK_STRING))) goto no_mem;
	} else if (__likely(flags == STK_FUNC)) {
		opf = FIND_FUNCTION(op);
		if (__unlikely(!opf)) KERNEL$SUICIDE("EVAL_UNTIL: UNKNOWN FUNCTION \"%s\"", op);
		if (__likely(opf->arguments != -1) && __unlikely(opf->arguments != 1)) goto args;
		res = opf->function(ctx, 1, &stack->entries[stack->n_entries - 1], op);
		POP(stack);
		POP(stack);
		goto do_result;
	} else KERNEL$SUICIDE("EVAL_UNTIL: FLAGS %d, OPERATION \"%s\"", flags, op);
	goto retry;
}

char *EVAL_EXPRESSION(CTX *ctx, const char *s, const char *e, int *fr)
{
	STACK stack = { 0, NULL, NULL };
	const char *t;
	int l;
	int i, j;
	char *d;
	const char *v;
	*fr = 0;

	STATE_1:
	NEXT_TOK(&s, e, &t, &l);
	if (__unlikely(!l)) goto syn_err;
	if (__unlikely(t[0] == '%') && __likely(l == 1)) {
		int fr = 0;
		char *x;
		if (__likely(s < e) && __unlikely(s[0] == '(')) {
			goto STATE_1;
		}
		s--;
		x = find_var_name(ctx, &s, e, 1, &fr);
		if (__unlikely(!x)) {
			l = 0;
			for (i = 1; i < ctx->p->rq->narg; i++) l += strlen(ctx->p->rq->arg[i]) + 1;
			if (__unlikely(!l)) l = 1;
			if (__unlikely(!(x = d = __sync_malloc(l)))) goto no_mem;
			d[0] = 0;
			for (i = 1; i < ctx->p->rq->narg; i++) {
				if (i != 1) *x++ = ' ';
				x = stpcpy(x, ctx->p->rq->arg[i]);
			}
		} else if (__unlikely(x == (void *)1)) {
			KERNEL$SUICIDE("EVAL_EXPRESSION: find_var_name RETURNED 1");
		} else {
			if (__likely(!fr)) {
				if (__unlikely(!(d = __sync_malloc(strlen(x) + 1)))) goto no_mem;
				strcpy(d, x);
			} else d = x;
		}
		if (__unlikely(PUSH(&stack, d, STK_STRING))) goto no_mem;
		goto STATE_2;
	}
	if (__unlikely(t[0] == '(') && __likely(l == 1)) {
		if (__unlikely(PUSH(&stack, NULL, STK_BRACKET))) goto no_mem;
		goto STATE_1;
	}
	if (__unlikely(t[0] == ')') && __likely(l == 1)) {
		if (__unlikely(!stack.n_entries) || __unlikely(stack.flags[stack.n_entries - 1] != STK_TO)) goto syn_err;
		if (__unlikely(!(d = __sync_malloc(11)))) goto no_mem;
		strcpy(d, "2147483647");
		if (__unlikely(PUSH(&stack, d, STK_STRING))) goto no_mem;
		goto cb;
	}
	if (__unlikely(l == 2) && __unlikely(__upcasechr(t[0]) == 'T') && __likely(__upcasechr(t[1]) == 'O')) {
		if (__unlikely(!stack.n_entries) || __unlikely(stack.flags[stack.n_entries - 1] != STK_SUBSTRING)) goto syn_err;
		if (__unlikely(!(d = __sync_malloc(2)))) goto no_mem;
		d[0] = '1';
		d[1] = 0;
		if (__unlikely(PUSH(&stack, d, STK_STRING))) goto no_mem;
		if (__unlikely(PUSH(&stack, NULL, STK_TO))) goto no_mem;
		goto STATE_1;
	}
	if (__unlikely(t[0] == '"')) {
		if (__unlikely(t[l - 1] != '"')) goto syn_err;
		if (__unlikely(!(d = __sync_malloc(l - 1)))) goto no_mem;
		j = 0;
		for (i = 1; i < l - 1; i++) {
			if (__unlikely((d[j++] = t[i]) == '"')) i++;
		}
		d[j] = 0;
		if (__unlikely(PUSH(&stack, d, STK_STRING))) goto no_mem;
	} else if ((__likely(t[0] >= '0') && t[0] <= '9') || __unlikely(t[0] == '#')) {
		for (i = 1; i < l; i++) if (!((__unlikely(t[i] >= '0') && __unlikely(t[i] <= '9')) || (t[0] == '#' && __upcasechr(t[i]) >= 'A' && __upcasechr(t[i]) <= 'F'))) goto syn_err;
		if (__unlikely(!(d = __sync_malloc(l + 1)))) goto no_mem;
		memcpy(d, t, l);
		d[l] = 0;
		if (__unlikely(PUSH(&stack, d, STK_STRING))) goto no_mem;
	} else {
		FUNCTION *opf;
		if (__unlikely(!(d = __sync_malloc(l + 1)))) goto no_mem;
		memcpy(d, t, l);
		d[l] = 0;
		if ((opf = FIND_FUNCTION(d))) {
			if (!opf->arguments) {
				char *res = opf->function(ctx, 0, NULL, d);
				free(d);
				if (__unlikely(res == (void *)1)) goto no_mem;
				if (__unlikely(!res)) goto fs;
				if (__unlikely(PUSH(&stack, res, STK_STRING))) goto no_mem;
				goto STATE_2;
			}
			if (__unlikely(PUSH(&stack, d, STK_FUNC))) goto no_mem;
			goto STATE_1;
		}
		for (i = 0; i < l; i++) if (__unlikely(!is_var_char(d[i]))) {
			free(d);
			goto syn_err;
		}
		if (__unlikely(!(v = find_var_env(ctx, d)))) goto no_var;
		free(d);
		i = strlen(v);
		if (__unlikely(!(d = __sync_malloc(i + 1)))) goto no_mem;
		memcpy(d, v, i);
		d[i] = 0;
		if (__unlikely(PUSH(&stack, d, STK_STRING))) goto no_mem;
	}

	STATE_2:
	NEXT_TOK(&s, e, &t, &l);
	if (__unlikely(!l)) {
		if (__unlikely(EVAL_UNTIL(ctx, &stack, PRIO_LOWEST))) goto fs;
		if (__unlikely(stack.n_entries != 1)) goto syn_err;
		if (__unlikely(stack.flags[0] != STK_STRING))
			KERNEL$SUICIDE("EVAL_EXPRESSION: TYPE %d LEFT ON STACK", stack.flags[0]);
		d = stack.entries[0];
		free(stack.entries);
		free(stack.flags);
		*fr = 1;
		return d;
	} else if (__unlikely(t[0] == ')') && __likely(l == 1)) {
		cb:
		if (__unlikely(EVAL_UNTIL(ctx, &stack, PRIO_LOWEST))) goto fs;
		if (__unlikely(stack.n_entries < 2)) goto syn_err;
		if (__unlikely(stack.flags[stack.n_entries - 2] != STK_BRACKET)) {
			char f;
			FUNCTION *opf;
			char *res;
			int to = 0;
			j = 1;
			nxa:
			if (__unlikely(j << 1 >= stack.n_entries)) goto syn_err;
			f = stack.flags[stack.n_entries - (j << 1)];
			if (__likely(f == STK_COMMA)) {
				nxaa:
				j++;
				goto nxa;
			}
			if (__unlikely(f == STK_TO)) {
				to = 1;
				goto nxaa;
			}
			if (__unlikely(f == STK_SUBSTRING)) {
				if (j == 1) {
					res = subchr(ctx, stack.entries[stack.n_entries - 3], stack.entries[stack.n_entries - 1]);
					goto dn;
				}
				if (__unlikely(j != 2) || __unlikely(!to)) goto syn_err;
				res = substr(ctx, stack.entries[stack.n_entries - 5], stack.entries[stack.n_entries - 3], stack.entries[stack.n_entries - 1]);
				goto dn;
			} else if (__unlikely(f != STK_BRACKET)) goto syn_err;
			if (__unlikely(stack.flags[stack.n_entries - (j << 1) - 1] != STK_FUNC)) goto syn_err;
			if (__unlikely(to)) goto syn_err;
			opf = FIND_FUNCTION(stack.entries[stack.n_entries - (j << 1) - 1]);
			if (__unlikely(!opf)) KERNEL$SUICIDE("EVAL_EXPRESSION: UNKNOWN FUNCTION \"%s\"", stack.entries[stack.n_entries - (j << 1) - 1]);
			if (__likely(opf->arguments != -1) && __unlikely(opf->arguments != j)) {
				_snprintf(ctx->return_msg, __MAX_STR_LEN, "WRONG NUMBER OF ARGUMENTS TO FUNCTION IN EXPRESSION");
				ctx->return_val = -EBADSYN;
				ctx->internal_flags |= SHELL_THREAD_ERROR;
				goto fs;
			}
			res = opf->function(ctx, j, &stack.entries[stack.n_entries - (j << 1) + 1], stack.entries[stack.n_entries - (j << 1) - 1]);
			dn:
			if (__unlikely(res == (void *)1)) goto no_mem;
			if (__unlikely(!res)) goto fs;
			for (i = 0; i < (j << 1) + 1; i++) POP(&stack);
			if (__unlikely(PUSH(&stack, res, STK_STRING))) goto no_mem;
			goto STATE_2;
		} else {
			free(stack.entries[stack.n_entries - 2]);
			stack.entries[stack.n_entries - 2] = stack.entries[stack.n_entries - 1];
			stack.flags[stack.n_entries - 2] = stack.flags[stack.n_entries - 1];
			stack.n_entries--;
			goto STATE_2;
		}
	} else if (__unlikely(t[0] == ',') && __likely(l == 1)) {
		if (__unlikely(EVAL_UNTIL(ctx, &stack, PRIO_LOWEST))) goto fs;
		if (__unlikely(PUSH(&stack, NULL, STK_COMMA))) goto no_mem;
	} else if (__unlikely(t[0] == '(') && __likely(l == 1)) {
		if (__unlikely(PUSH(&stack, NULL, STK_SUBSTRING))) goto no_mem;
	} else if (__unlikely(l == 2) && __unlikely(__upcasechr(t[0]) == 'T') && __likely(__upcasechr(t[1]) == 'O')) {
		if (__unlikely(EVAL_UNTIL(ctx, &stack, PRIO_LOWEST))) goto fs;
		if (__unlikely(PUSH(&stack, NULL, STK_TO))) goto no_mem;
	} else {
		int pri;
		if (__unlikely(!(d = __sync_malloc(l + 1)))) goto no_mem;
		memcpy(d, t, l);
		d[l] = 0;
		if (__unlikely(!FIND_OPERATOR(d))) {
			free(d);
			goto syn_err;
		}
		pri = GET_PRIO(d, STK_OPERATOR);
		if (__unlikely(EVAL_UNTIL(ctx, &stack, pri))) {
			free(d);
			goto fs;
		}
		if (__unlikely(PUSH(&stack, d, STK_OPERATOR))) goto no_mem;
	}
	goto STATE_1;

	syn_err:
	_snprintf(ctx->return_msg, __MAX_STR_LEN, "EXPRESSION SYNTAX ERROR");
	ctx->return_val = -EBADSYN;
	ctx->internal_flags |= SHELL_THREAD_ERROR;
	fs:
	FREE_STACK(&stack);
	return "";

	no_var:
	_snprintf(ctx->return_msg, __MAX_STR_LEN, "VARIABLE \"%s\" NOT FOUND", d);
	ctx->return_val = -ENOENT;
	ctx->internal_flags |= SHELL_THREAD_ERROR;
	free(d);
	goto fs;

	no_mem:
	_snprintf(ctx->return_msg, __MAX_STR_LEN, "OUT OF MEMORY FOR EXPRESSION");
	ctx->return_val = -ENOMEM;
	ctx->internal_flags |= SHELL_THREAD_ERROR;
	goto fs;
}

