#include <SPAD/LIBC.H>
#include <SPAD/DL.H>
#include <SPAD/LIST.H>
#include <SPAD/ALLOC.H>
#include <SPAD/VM.H>
#include <SPAD/HASH.H>
#include <SPAD/DEV.H>
#include <SPAD/READDIR.H>
#include <DIRENT.H>
#include <SYS/STAT.H>
#include <SPAD/IOCTL.H>
#include <UNISTD.H>
#include <SYS/IOCTL.H>
#include <STDLIB.H>

#include "SHELL.H"

static AST_STUB SHELL_CHECKED_IN;
static AST_STUB SHELL_CHECKED_OUT;
static AST_STUB SHELL_CHECKED_ERR;
static AST_STUB SHELL_INT_ALLOC;
static AST_STUB SHELL_INT_ALLOCATED;
static AST_STUB SHELL_INT_BUFFER_ALLOCATED;
static AST_STUB SHELL_INT_READ;
static AST_STUB SHELL_INT_WROTE_PROMPT;
static AST_STUB SHELL_INT_GOT_DATA;
static AST_STUB SHELL_INT_HIST_OPEN;
static AST_STUB SHELL_INT_HIST_WROTE;
static AST_STUB SHELL_INT_HIST_ALLOC;
static AST_STUB SHELL_INT_HIST_ALLOCATED;
static AST_STUB SHELL_INT_PROCESS_CMD;
static AST_STUB SHELL_INT_CMD_EXIT;
static AST_STUB SHELL_INT_HISTORY_GO_1;
static AST_STUB SHELL_INT_HISTORY_GO;
static AST_STUB SHELL_INT_HISTORY_NO_MOVE;
static AST_STUB SHELL_INT_HISTORY_PUT_READ;
static AST_STUB SHELL_INT_NO_COMP;
static AST_STUB SHELL_INT_WROTE_7;
static AST_STUB SHELL_INT_PUTBACK;
static AST_STUB SHELL_INT_PUTBACK_RV;
static AST_STUB SHELL_INT_EXIT;
static AST_STUB SHELL_INT_EXIT_HIST_OPEN;
static AST_STUB SHELL_INT_EXIT_HIST;
static AST_STUB SHELL_INT_EXIT_HIST_WROTE;
static AST_STUB SHELL_INT_FILE_PREVIOUS;
static AST_STUB SHELL_INT_FP_OPEN;
static AST_STUB SHELL_INT_FP_SEEKED;
static AST_STUB SHELL_INT_FP_READ;
static AST_STUB SHELL_INT_FP_PUT;
static AST_STUB SHELL_INT_FWD_SEEKED;
static AST_STUB SHELL_INT_FWD_READ;
static AST_STUB SHELL_INT_COMPLETION;
static AST_STUB SHELL_INT_COMP_ALLOCATED;
static AST_STUB SHELL_INT_COMP_RDDIR;
static AST_STUB SHELL_INT_COMP_ALLOC2;
static AST_STUB SHELL_INT_COMP_OPEN;
static AST_STUB SHELL_INT_COMP_STAT;
static AST_STUB SHELL_INT_COMPL_QUOTE_ARG;
static AST_STUB SHELL_INT_COMPL_PUSH1;
static AST_STUB SHELL_INT_COMPL_PUSH2;
static AST_STUB SHELL_INT_COMPL_PUSH3;
static AST_STUB SHELL_INT_COMPL_CLR_2T;
static AST_STUB SHELL_INT_COMP_LS_CHECK2;
static AST_STUB SHELL_INT_COMP_LS_WINSIZE;
static AST_STUB SHELL_INT_COMP_LS_ALLOC_COL;
static AST_STUB SHELL_INT_COMP_LS_WRITE;
static AST_STUB SHELL_INT_COMP_LS_WROTE;
static AST_STUB SHELL_INT_COMP_LS_WROTE_2;
static AST_STUB SHELL_INT_COMP_LS_DONE;
static AST_STUB SHELL_INT_COMP_WROTE_PROMPT;

#define INT_BUFFER_SIZE 128;

static void MAKE_PROMPT(CTX *RQ)
{
	int l;
	const char *c;
	memcpy(&RQ->scratch_1[0], PROMPT_PREFIX, PROMPT_PREFIX_LEN);
	set_color(RQ, RQ->color, RQ->modified_color | 0x4000, &RQ->scratch_1[PROMPT_PREFIX_LEN]);
	c = KERNEL$GET_CWD(RQ->cwd);
	if (__unlikely(!c)) c = "";
	l = strlen(RQ->scratch_1);
	_snprintf(RQ->scratch_1 + l, SCRATCH_1_LEN - l, "%s%c", c, FEATURE_ALT8(FEATURE_USERSPACE, '!', '>'));
	__upcase(RQ->scratch_1 + l);
}

DECL_AST(SHELL_INT_COMMAND, SPL_SHELL, CTX)
{
	if (__unlikely(RQ->argv[1] != NULL)) {
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "INT: SYNTAX ERROR");
		RQ->return_val = -EBADSYN;
		RETURN_TO_SHELL(RQ);
	}
	if (__unlikely(RQ->ctty_in < 0) || __unlikely(RQ->ctty_out < 0) || __unlikely(RQ->ctty_err < 0)) {
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "INT: NO CONTROL TERMINAL");
		RQ->return_val = -EINVAL;
		RETURN_TO_SHELL(RQ);
	}
	RQ->itmp1 = 1;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_GET_TERM_FLAGS;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = 0;
	RQ->u.ioctlrq.v.len = 0;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.fn = SHELL_CHECKED_IN;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, &KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_CHECKED_IN, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		RQ->itmp1 = 0;
		CALL_SHELL_FN(RQ, SHELL_INT_ALLOC);
	}
	RQ->u.ioctlrq.h = RQ->ctty_out;
	RQ->u.ioctlrq.fn = SHELL_CHECKED_OUT;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, &KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_CHECKED_OUT, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		RQ->itmp1 = 0;
		CALL_SHELL_FN(RQ, SHELL_INT_ALLOC);
	}
	RQ->u.ioctlrq.h = RQ->ctty_err;
	RQ->u.ioctlrq.fn = SHELL_CHECKED_ERR;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, &KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_CHECKED_ERR, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		RQ->itmp1 = 0;
	}
	CALL_SHELL_FN(RQ, SHELL_INT_ALLOC);
}

static DECL_AST(SHELL_INT_ALLOC, SPL_SHELL, CTX)
{
	RQ->u.mrq.fn = &SHELL_INT_ALLOCATED;
	RQ->u.mrq.size = sizeof(INTX);
	RETURN_IORQ_CANCELABLE(&RQ->u.mrq, &KERNEL$UNIVERSAL_MALLOC, RQ->p->rq);
}

static DECL_AST(SHELL_INT_ALLOCATED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		if (RQ->u.mrq.status != -EINTR) _snprintf(RQ->return_msg, __MAX_STR_LEN, "INT: CAN'T ALLOCATE: %s", strerror(-RQ->u.mrq.status));
		RQ->return_val = RQ->u.mrq.status;
		RETURN_TO_SHELL(RQ);
	}
	RQ->vtmp1 = RQ->u.mrq.ptr;
	RQ->u.mrq.fn = &SHELL_INT_BUFFER_ALLOCATED;
	RQ->u.mrq.size = INT_BUFFER_SIZE;
	RETURN_IORQ_CANCELABLE(&RQ->u.mrq, &KERNEL$UNIVERSAL_MALLOC, RQ->p->rq);
}

static DECL_AST(SHELL_INT_BUFFER_ALLOCATED, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		free(RQ->vtmp1);
		if (RQ->u.mrq.status != -EINTR) _snprintf(RQ->return_msg, __MAX_STR_LEN, "INT: CAN'T ALLOCATE: %s", strerror(-RQ->u.mrq.status));
		RQ->return_val = RQ->u.mrq.status;
		RETURN_TO_SHELL(RQ);
	}
	intx = RQ->vtmp1;
	intx->buf = RQ->u.mrq.ptr;
	intx->buf_size = INT_BUFFER_SIZE;
	intx->buf_ptr = 0;
	intx->doexit = 0;
	intx->print_prompt = RQ->itmp1;
	intx->link = RQ->intx;
	RQ->intx = intx;
	RQ->itmp1 = 1;
	RQ->itmp2 = -1;
	CALL_SHELL_FN(RQ, SHELL_INT_READ);
}

static DECL_AST(SHELL_INT_BUFFER_EXPANDED, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		if (RQ->u.mrq.status != -EINTR) _snprintf(RQ->return_msg, __MAX_STR_LEN, "CAN'T EXPAND BUFFER: %s", strerror(-RQ->u.mrq.status));
		RQ->return_val = RQ->u.mrq.status;
		CALL_SHELL_FN(RQ, &SHELL_INT_EXIT);
	}
	intx = RQ->intx;
	memcpy(RQ->u.mrq.ptr, intx->buf, intx->buf_size);
	free(intx->buf);
	intx->buf = RQ->u.mrq.ptr;
	intx->buf_size = RQ->u.mrq.size;
	CALL_SHELL_FN(RQ, &SHELL_INT_READ);
}

static DECL_AST(SHELL_INT_READ, SPL_SHELL, CTX)
{
	if (RQ->itmp1 && __likely(RQ->intx->print_prompt)) {
		MAKE_PROMPT(RQ);
		RQ->u.siorq.fn = &SHELL_INT_WROTE_PROMPT;
		RQ->u.siorq.h = RQ->ctty_out;
		RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
		RQ->u.siorq.v.len = strlen(RQ->scratch_1);
		RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
		RQ->u.siorq.progress = 0;
		RQ->itmp1 = 0;
		RETURN_IORQ_CANCELABLE(&RQ->u.siorq, &KERNEL$WRITE, RQ->p->rq);
	}

	RQ->u.siorq.fn = &SHELL_INT_GOT_DATA;
	RQ->u.siorq.h = RQ->ctty_in;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->intx->buf + RQ->intx->buf_ptr;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.v.len = RQ->intx->buf_size - RQ->intx->buf_ptr;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, &KERNEL$READ, RQ->p->rq);
}

static DECL_AST(SHELL_INT_WROTE_PROMPT, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.siorq.status <= 0) || __likely(!RQ->u.siorq.v.len)) CALL_SHELL_FN(RQ, &SHELL_INT_READ);
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, &KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_GOT_DATA, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	intx = RQ->intx;
	if (__unlikely(RQ->u.siorq.status < 0)) {
		_snprintf(RQ->return_msg, __MAX_STR_LEN, "TTYIN: %s (%s)", strerror(-RQ->u.siorq.status), KERNEL$HANDLE_PATH(RQ->u.siorq.h));
		RQ->return_val = RQ->u.siorq.status;
		CALL_SHELL_FN(RQ, &SHELL_INT_EXIT);
	}
	/*{
		int i;
		__debug_printf("[");
		for (i = 0; i < RQ->u.siorq.status; i++)
			__debug_printf("%02x(%c)", intx->buf[intx->buf_ptr + i], intx->buf[intx->buf_ptr + i]);
		__debug_printf("]");
	}*/
	intx->buf_ptr += RQ->u.siorq.status;
	if (RQ->u.siorq.status == 0) intx->doexit = 1;
	CALL_SHELL_FN(RQ, &SHELL_INT_PROCESS_CMD);
}

static DECL_AST(SHELL_INT_PROCESS_CMD, SPL_SHELL, CTX)
{
	int i;
	INTX *intx = RQ->intx;
	if (!intx->buf_ptr) CALL_SHELL_FN(RQ, &SHELL_INT_EXIT);
	for (i = 0; i < intx->buf_ptr; i++) {
		if (intx->buf[i] == '\n') goto line;
		if (i >= 2 && __unlikely(intx->buf[i - 2] == '\e') && __likely(intx->buf[i - 1] == '[') && (__likely(intx->buf[i] == 'A') || __likely(intx->buf[i] == 'B'))) {
			RQ->itmp1 = i;
			CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_GO_1);
		}
		if (__unlikely(intx->buf[i] == '\t')) {
			RQ->itmp1 = i;
			CALL_SHELL_FN(RQ, SHELL_INT_COMPLETION);
		}
	}
	if (intx->doexit) {
		i = intx->buf_ptr;
		goto line;
	}
	if (intx->buf_ptr < intx->buf_size) CALL_SHELL_FN(RQ, &SHELL_INT_READ);
	RQ->u.mrq.fn = &SHELL_INT_BUFFER_EXPANDED;
	RQ->u.mrq.size = intx->buf_size + INT_BUFFER_SIZE;
	RETURN_IORQ_CANCELABLE(&RQ->u.mrq, &KERNEL$UNIVERSAL_MALLOC, RQ->p->rq);
	line:
	intx->rc.fn = &SHELL_INT_CMD_EXIT;
	intx->rc.ctx = RQ;
	intx->rc.ptr = intx->buf;
	intx->rc.len = i;
	intx->rc.arg = NULL;
	intx->rc.narg = 0;
	if (__likely(RQ->history[0] != NULL) && (intx->rc.len == strlen(RQ->history[0]) - 1) && !memcmp(intx->rc.ptr, RQ->history[0], intx->rc.len)) {
		RETURN_IORQ_CANCELABLE(&intx->rc, SHELL$RUN_COMMANDS, RQ->p->rq);
	}
	if (__unlikely(!intx->rc.len) || (__unlikely(intx->rc.len == 1) && __likely(*intx->rc.ptr == '\n')) || __unlikely(*intx->rc.ptr == ';')) {
		RETURN_IORQ_CANCELABLE(&intx->rc, SHELL$RUN_COMMANDS, RQ->p->rq);
	}
	if (!RQ->history[N_DIRECT_HISTORY - 1]) {
		CALL_SHELL_FN(RQ, SHELL_INT_HIST_ALLOC);
	}
	RQ->u.openrq.fn = SHELL_INT_HIST_OPEN;
	RQ->u.openrq.flags = O_WRONLY | O_APPEND | O_CREAT | _O_NOWAIT;
	RQ->u.openrq.path = HISTORY_FILE;
	RQ->u.openrq.cwd = RQ->cwd;
	RETURN_IORQ_CANCELABLE(&RQ->u.openrq, KERNEL$OPEN, RQ->p->rq);
}

static DECL_AST(SHELL_INT_HIST_OPEN, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.openrq.status < 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_HIST_ALLOC);
	}
	RQ->u.siorq.fn = SHELL_INT_HIST_WROTE;
	RQ->u.siorq.h = RQ->u.openrq.status;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->history[N_DIRECT_HISTORY - 1];
	RQ->u.siorq.v.len = strlen(RQ->history[N_DIRECT_HISTORY - 1]);
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_HIST_WROTE, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	KERNEL$FAST_CLOSE(RQ->u.siorq.h);
	CALL_SHELL_FN(RQ, SHELL_INT_HIST_ALLOC);
}

static DECL_AST(SHELL_INT_HIST_ALLOC, SPL_SHELL, CTX)
{
	INTX *intx = RQ->intx;
	RQ->u.mrq.fn = SHELL_INT_HIST_ALLOCATED;
	RQ->u.mrq.size = intx->rc.len + 2;
	RETURN_IORQ_CANCELABLE(&RQ->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ->p->rq);
}

static DECL_AST(SHELL_INT_HIST_ALLOCATED, SPL_SHELL, CTX)
{
	INTX *intx = RQ->intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) goto skip_alloc;
	free(RQ->history[N_DIRECT_HISTORY - 1]);
	memmove(RQ->history + 1, RQ->history, (N_DIRECT_HISTORY - 1) * sizeof(char *));
	RQ->history[0] = RQ->u.mrq.ptr;
	memcpy(RQ->history[0], intx->rc.ptr, intx->rc.len);
	if (__unlikely(!intx->rc.len) || __unlikely(RQ->history[0][intx->rc.len - 1] != '\n')) {
		RQ->history[0][intx->rc.len] = '\n';
		RQ->history[0][intx->rc.len + 1] = 0;
	} else {
		RQ->history[0][intx->rc.len] = 0;
	}
	skip_alloc:
	RETURN_IORQ_CANCELABLE(&intx->rc, SHELL$RUN_COMMANDS, RQ->p->rq);
}

static DECL_AST(SHELL_INT_CMD_EXIT, SPL_SHELL, SHRCRQ)
{
	CTX *ctx = RQ->ctx;
	INTX *intx = ctx->intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), ctx->p->rq);
	ctx->itmp1 = 1;
	ctx->itmp2 = -1;
	if (intx->doexit) CALL_SHELL_FN(ctx, &SHELL_INT_EXIT);
	if (intx->rc.len + 1 >= intx->buf_ptr) {
		intx->buf_ptr = 0;
		CALL_SHELL_FN(ctx, &SHELL_INT_READ);
	}
	memmove(intx->buf, intx->buf + intx->rc.len + 1, intx->buf_ptr - (intx->rc.len + 1));
	intx->buf_ptr -= intx->rc.len + 1;
	CALL_SHELL_FN(ctx, &SHELL_INT_PROCESS_CMD);
}

static DECL_AST(SHELL_INT_HISTORY_GO_1, SPL_SHELL, CTX)
{
	INTX *intx = RQ->intx;
	RQ->u.ioctlrq.fn = SHELL_INT_HISTORY_GO;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)intx->buf + RQ->itmp1 + 1;
	RQ->u.ioctlrq.v.len = intx->buf_ptr - (RQ->itmp1 + 1);
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_HISTORY_GO, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	intx = RQ->intx;
	if (intx->buf[RQ->itmp1] == 'A') {
		if (RQ->itmp2 < 0) {
			int x = - RQ->itmp2 - 1;
			if (x >= N_DIRECT_HISTORY || !RQ->history[x]) {
				CALL_SHELL_FN(RQ, SHELL_INT_FILE_PREVIOUS);
			}
			RQ->itmp2--;
			RQ->u.ioctlrq.fn = SHELL_INT_PUTBACK;
			RQ->u.ioctlrq.h = RQ->ctty_in;
			RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
			RQ->u.ioctlrq.param = 0;
			RQ->u.ioctlrq.v.ptr = (unsigned long)RQ->history[x];
			RQ->u.ioctlrq.v.len = strlen(RQ->history[x]) - 1;
			RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
			RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
		} else {
			if (__unlikely(!RQ->itmp2)) CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_NO_MOVE);
			CALL_SHELL_FN(RQ, SHELL_INT_FILE_PREVIOUS);
		}
	} else {
		if (RQ->itmp2 < 0) {
			int x = - RQ->itmp2 - 3;
			if (x < 0) {
				if (x == -2) CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_NO_MOVE);
				RQ->itmp2++;
				CALL_SHELL_FN(RQ, SHELL_INT_PUTBACK);
			}
			RQ->itmp2++;
			RQ->u.ioctlrq.fn = SHELL_INT_PUTBACK;
			RQ->u.ioctlrq.h = RQ->ctty_in;
			RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
			RQ->u.ioctlrq.param = 0;
			RQ->u.ioctlrq.v.ptr = (unsigned long)RQ->history[x];
			RQ->u.ioctlrq.v.len = strlen(RQ->history[x]) - 1;
			RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
			RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
		} else {
			CALL_SHELL_FN(RQ, SHELL_INT_FILE_PREVIOUS);
		}
	}
}

static DECL_AST(SHELL_INT_HISTORY_NO_MOVE, SPL_SHELL, CTX)
{
	INTX *intx = RQ->intx;
	RQ->u.ioctlrq.fn = SHELL_INT_PUTBACK;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)intx->buf;
	RQ->u.ioctlrq.v.len = RQ->itmp1 - 2;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_NO_COMP, SPL_SHELL, CTX)
{
	if (__unlikely(RQ->ctty_err < 0)) CALL_SHELL_FN(RQ, SHELL_INT_WROTE_7);
	RQ->u.siorq.fn = SHELL_INT_WROTE_7;
	RQ->u.siorq.h = RQ->ctty_err;
	RQ->u.siorq.v.ptr = (unsigned long)"\007";
	RQ->u.siorq.v.len = 1;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_WROTE_7, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	intx = RQ->intx;
	memmove(&intx->buf[RQ->itmp1], &intx->buf[RQ->itmp1 + 1], intx->buf_ptr - (RQ->itmp1 + 1));
	intx->buf_ptr--;
	CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_PUT_READ);
}

static DECL_AST(SHELL_INT_HISTORY_PUT_READ, SPL_SHELL, CTX)
{
	INTX *intx = RQ->intx;
	RQ->u.ioctlrq.fn = SHELL_INT_PUTBACK;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)intx->buf;
	RQ->u.ioctlrq.v.len = intx->buf_ptr;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_PUTBACK, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	RQ->u.ioctlrq.fn = SHELL_INT_PUTBACK_RV;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK_EDIT;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = 0;
	RQ->u.ioctlrq.v.len = 0;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_PUTBACK_RV, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	intx = RQ->intx;
	intx->buf_ptr = 0;
	RQ->itmp1 = 0;
	CALL_SHELL_FN(RQ, SHELL_INT_READ);
}

static DECL_AST(SHELL_INT_EXIT, SPL_SHELL, CTX)
{
	INTX *intx = RQ->intx;
	RQ->intx = intx->link;
	free(intx->buf);
	free(intx);
	RQ->u.openrq.fn = SHELL_INT_EXIT_HIST_OPEN;
	RQ->u.openrq.flags = O_WRONLY | O_APPEND | O_CREAT | _O_NOWAIT;
	RQ->u.openrq.path = HISTORY_FILE;
	RQ->u.openrq.cwd = RQ->cwd;
	RETURN_IORQ_CANCELABLE(&RQ->u.openrq, KERNEL$OPEN, RQ->p->rq);
}

static DECL_AST(SHELL_INT_EXIT_HIST_OPEN, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.openrq.status) < 0) RETURN_TO_SHELL(RQ);
	RQ->u.siorq.h = RQ->u.openrq.status;
	CALL_SHELL_FN(RQ, SHELL_INT_EXIT_HIST);
}

static DECL_AST(SHELL_INT_EXIT_HIST, SPL_SHELL, CTX)
{
	int i;
	if (__unlikely(!RQ->history[0])) {
		KERNEL$FAST_CLOSE(RQ->u.siorq.h);
		RETURN_TO_SHELL(RQ);
	}
	for (i = 1; i < N_DIRECT_HISTORY && RQ->history[i]; i++) ;
	i--;
	RQ->u.siorq.fn = SHELL_INT_EXIT_HIST_WROTE;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->history[i];
	RQ->u.siorq.v.len = strlen(RQ->history[i]);
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RQ->itmp1 = i;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_EXIT_HIST_WROTE, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	free(RQ->history[RQ->itmp1]);
	RQ->history[RQ->itmp1] = NULL;
	if (__unlikely(RQ->u.siorq.status < 0) || __unlikely(RQ->u.siorq.v.len)) {
		KERNEL$FAST_CLOSE(RQ->u.siorq.h);
		RETURN_TO_SHELL(RQ);
	}
	CALL_SHELL_FN(RQ, SHELL_INT_EXIT_HIST);
}

static DECL_AST(SHELL_INT_FILE_PREVIOUS, SPL_SHELL, CTX)
{
	RQ->u.openrq.fn = SHELL_INT_FP_OPEN;
	RQ->u.openrq.flags = O_RDONLY | _O_NOWAIT;
	RQ->u.openrq.path = HISTORY_FILE;
	RQ->u.openrq.cwd = RQ->cwd;
	RETURN_IORQ_CANCELABLE(&RQ->u.openrq, KERNEL$OPEN, RQ->p->rq);
}

static DECL_AST(SHELL_INT_FP_OPEN, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.openrq.status < 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_NO_MOVE);
	}
	RQ->itmp3 = RQ->u.openrq.status;
	intx = RQ->intx;
	if (__likely(intx->buf[RQ->itmp1] == 'A')) {
		RQ->itmp4 = SCRATCH_1_LEN;
		RQ->otmp1 = RQ->itmp2 < 0 ? -SCRATCH_1_LEN - 1 : RQ->itmp2 - SCRATCH_1_LEN - 1;
		if (RQ->itmp2 > 0) RQ->itmp2--;
		RQ->u.ioctlrq.fn = SHELL_INT_FP_SEEKED;
		RQ->u.ioctlrq.h = RQ->itmp3;
		RQ->u.ioctlrq.ioctl = IOCTL_LSEEK;
		RQ->u.ioctlrq.param = RQ->itmp2 < 0 ? SEEK_END : SEEK_SET;
		RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->otmp1;
		RQ->u.ioctlrq.v.len = sizeof(off_t);
		RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
	} else {
		RQ->otmp1 = RQ->itmp2;
		RQ->u.ioctlrq.fn = SHELL_INT_FWD_SEEKED;
		RQ->u.ioctlrq.h = RQ->itmp3;
		RQ->u.ioctlrq.ioctl = IOCTL_LSEEK;
		RQ->u.ioctlrq.param = SEEK_SET;
		RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->otmp1;
		RQ->u.ioctlrq.v.len = sizeof(off_t);
		RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
	}
}

static DECL_AST(SHELL_INT_FP_SEEKED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.ioctlrq.status < 0)) {
		KERNEL$FAST_CLOSE(RQ->itmp3);
		CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_NO_MOVE);
	}
	if (__unlikely(RQ->otmp1 < 0)) {
		RQ->itmp4 = SCRATCH_1_LEN + (int)RQ->otmp1;
		RQ->otmp1 = 0;
		RQ->u.ioctlrq.fn = SHELL_INT_FP_SEEKED;
		RQ->u.ioctlrq.h = RQ->itmp3;
		RQ->u.ioctlrq.ioctl = IOCTL_LSEEK;
		RQ->u.ioctlrq.param = SEEK_SET;
		RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->otmp1;
		RQ->u.ioctlrq.v.len = sizeof(off_t);
		RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
	}
	if (__unlikely(RQ->itmp4 <= 0)) {
		KERNEL$FAST_CLOSE(RQ->itmp3);
		CALL_SHELL_FN(RQ, SHELL_INT_PUTBACK);
	}
	if (RQ->itmp2 < 0) RQ->itmp2 = RQ->otmp1 + RQ->itmp4;
	RQ->u.siorq.fn = SHELL_INT_FP_READ;
	RQ->u.siorq.h = RQ->itmp3;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
	RQ->u.siorq.v.len = RQ->itmp4;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$READ, RQ->p->rq);
}

static DECL_AST(SHELL_INT_FP_READ, SPL_SHELL, CTX)
{
	int i;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.siorq.status <= 0)) {
		KERNEL$FAST_CLOSE(RQ->itmp3);
		CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_NO_MOVE);
	}
	for (i = RQ->u.siorq.status - 1; i >= 0; i--) {
		if (RQ->scratch_1[i] == '\n') break;
	}
	i++;
	RQ->u.ioctlrq.fn = SHELL_INT_FP_PUT;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->scratch_1[i];
	RQ->u.ioctlrq.v.len = RQ->u.siorq.status - i;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RQ->itmp2 -= RQ->u.ioctlrq.v.len;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_FP_PUT, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if ((unsigned long)RQ->u.ioctlrq.v.ptr == (unsigned long)&RQ->scratch_1) {
		RQ->itmp4 = SCRATCH_1_LEN;
		RQ->otmp1 = (off_t)-SCRATCH_1_LEN - RQ->u.ioctlrq.v.len;
		RQ->u.ioctlrq.fn = SHELL_INT_FP_SEEKED;
		RQ->u.ioctlrq.h = RQ->itmp3;
		RQ->u.ioctlrq.ioctl = IOCTL_LSEEK;
		RQ->u.ioctlrq.param = SEEK_CUR;
		RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->otmp1;
		RQ->u.ioctlrq.v.len = sizeof(off_t);
		RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
	}
	KERNEL$FAST_CLOSE(RQ->itmp3);
	CALL_SHELL_FN(RQ, SHELL_INT_PUTBACK);
}

static DECL_AST(SHELL_INT_FWD_SEEKED, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.ioctlrq.status < 0)) {
		KERNEL$FAST_CLOSE(RQ->itmp3);
		CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_NO_MOVE);
	}
	RQ->itmp4 = 0;
	RQ->u.siorq.fn = SHELL_INT_FWD_READ;
	RQ->u.siorq.h = RQ->itmp3;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
	RQ->u.siorq.v.len = SCRATCH_1_LEN;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$READ, RQ->p->rq);
}

static DECL_AST(SHELL_INT_FWD_READ, SPL_SHELL, CTX)
{
	int i;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.siorq.status <= 0)) {
		KERNEL$FAST_CLOSE(RQ->itmp3);
		for (i = N_DIRECT_HISTORY - 1; i >= 0; i--) if (RQ->history[i]) break;
		RQ->itmp2 = - i - 3;
		CALL_SHELL_FN(RQ, SHELL_INT_HISTORY_GO);
	}
	for (i = 0; i < RQ->u.siorq.status; i++) {
		if (RQ->scratch_1[i] == '\n' && ++RQ->itmp4 == 2) {
			i++;
			break;
		}
	}
	RQ->itmp2 += i;
	if (RQ->itmp4 == 2) {
		RQ->itmp4 = SCRATCH_1_LEN;
		RQ->otmp1 = RQ->itmp2 - SCRATCH_1_LEN - 1;
		RQ->itmp2--;
		RQ->u.ioctlrq.fn = SHELL_INT_FP_SEEKED;
		RQ->u.ioctlrq.h = RQ->itmp3;
		RQ->u.ioctlrq.ioctl = IOCTL_LSEEK;
		RQ->u.ioctlrq.param = SEEK_SET;
		RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->otmp1;
		RQ->u.ioctlrq.v.len = sizeof(off_t);
		RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
	}
	RQ->u.siorq.fn = SHELL_INT_FWD_READ;
	RQ->u.siorq.h = RQ->itmp3;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
	RQ->u.siorq.v.len = SCRATCH_1_LEN;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$READ, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMPLETION, SPL_SHELL, CTX)
{
	RQ->u.mrq.size = RQ->itmp1 + 9;
	RQ->u.mrq.fn = SHELL_INT_COMP_ALLOCATED;
	RETURN_IORQ_CANCELABLE(&RQ->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_ALLOCATED, SPL_SHELL, CTX)
{
	INTX *intx;
	unsigned ptr, mode, ctp, i;
	char *p;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_NO_COMP);
	}
	/*
	free(RQ->u.mrq.ptr);
	CALL_SHELL_FN(RQ, SHELL_INT_NO_COMP);
	*/
	RQ->ctmp1 = RQ->u.mrq.ptr;
	intx = RQ->intx;
	ptr = 0;
	mode = 1;
	ctp = 0;
	for (i = 0; i < RQ->itmp1; i++) {
		unsigned char c = intx->buf[i];
		if (__unlikely(c == ';') || (__unlikely(c == ' ') && __likely(i >= 5) && !_memcasecmp(&intx->buf[i - 5], " THEN ", 6))) {
			ptr = i + 1;
			mode = 1;
			ctp = 0;
			continue;
		}
		if (__unlikely(c <= ' ') || __unlikely(c == '=') || __unlikely(c == ',')) {
			ptr = i + 1;
			if (__unlikely(c > ' ') || __likely(ctp)) mode = 0;
			ctp = 0;
			continue;
		}
		if (__unlikely(c == '"') || __unlikely(c == '\'')) {
			i++;
			while (i < RQ->itmp1 && intx->buf[i] != c) {
				RQ->ctmp1[ctp++] = intx->buf[i];
				i++;
			}
			continue;
		}
		RQ->ctmp1[ctp++] = c;
	}
	RQ->itmp3 = ptr;
	RQ->ctmp1[ctp] = 0;
	p = strrchr(RQ->ctmp1, '/');
	if (!p) p = strrchr(RQ->ctmp1, ':');
	if (!p) {
		if (mode) {
			memmove(RQ->ctmp1 + 8, RQ->ctmp1, strlen(RQ->ctmp1) + 1);
			memcpy(RQ->ctmp1, "PATH.:/", 8);
			RQ->vtmp1 = RQ->ctmp1 + 7;
		} else {
			memmove(RQ->ctmp1 + 2, RQ->ctmp1, strlen(RQ->ctmp1) + 1);
			memcpy(RQ->ctmp1, ".", 2);
			RQ->vtmp1 = RQ->ctmp1 + 1;
		}
	} else {
		if (__unlikely(mode)) mode = 2;
		memmove(p + 2, p + 1, strlen(p + 1) + 1);
		p[1] = 0;
		RQ->vtmp1 = RQ->ctmp1;
	}
	RQ->itmp7 = mode;
	RQ->u2.rddir_rq.fn = SHELL_INT_COMP_RDDIR;
	RQ->u2.rddir_rq.flags = _O_NOWAIT;
	RQ->u2.rddir_rq.path = RQ->ctmp1;
	RQ->u2.rddir_rq.cwd = RQ->cwd;
	RETURN_IORQ_CANCELABLE(&RQ->u2.rddir_rq, KERNEL$READDIR, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_RDDIR, SPL_SHELL, READDIR_RQ)
{
	CTX *ctx = GET_STRUCT(RQ, CTX, u2.rddir_rq);
	unsigned i, j, pl;
	unsigned m, l;
	char *p;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), ctx->p->rq);
	if (__unlikely(ctx->u2.rddir_rq.status < 0)) {
		free(ctx->ctmp1);
		CALL_SHELL_FN(ctx, SHELL_INT_NO_COMP);
	}
	p = ctx->ctmp1 + strlen(ctx->ctmp1) + 1;
	pl = strlen(p);
	for (i = 0, j = 0; i < ctx->u2.rddir_rq.n_entries; i++) {
		if (__unlikely(strlen(ctx->u2.rddir_rq.entries[i]->d_name) < pl) || __unlikely(_memcasecmp(ctx->u2.rddir_rq.entries[i]->d_name, p, pl))) continue;
		if (!ctx->itmp7) {
			w:
			ctx->u2.rddir_rq.entries[j++] = ctx->u2.rddir_rq.entries[i];
		} else {
			unsigned k = strlen(ctx->u2.rddir_rq.entries[i]->d_name);
			if (ctx->itmp7 == 2 && ctx->u2.rddir_rq.entries[i]->d_type == DT_DIR) goto w;
			if (__likely(k > 4) && (!_memcasecmp(ctx->u2.rddir_rq.entries[i]->d_name + k - 4, ".EXE", 4) || !_memcasecmp(ctx->u2.rddir_rq.entries[i]->d_name + k - 4, ".CMD", 4))) {
				ctx->u2.rddir_rq.entries[i]->d_name[k - 4] = 0;
				goto w;
			}
		}
	}
	if (__unlikely(!j)) {
		KERNEL$FREE_READDIR(&ctx->u2.rddir_rq);
		free(ctx->ctmp1);
		CALL_SHELL_FN(ctx, SHELL_INT_NO_COMP);
	}
	ctx->itmp7 = j;
	m = 0;
	for (i = 0; i < j; i++) if (__likely((l = (ctx->itmp1 + strlen(ctx->u2.rddir_rq.entries[i]->d_name)) * 3 + 2) > m)) m = l;
	ctx->u.mrq.fn = SHELL_INT_COMP_ALLOC2;
	ctx->u.mrq.size = m;
	RETURN_IORQ_CANCELABLE(&ctx->u.mrq, KERNEL$UNIVERSAL_MALLOC, ctx->p->rq);
}

static DECL_AST(SHELL_INT_COMP_ALLOC2, SPL_SHELL, CTX)
{
	int i, j, l;
	char *q;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		KERNEL$FREE_READDIR(&RQ->u2.rddir_rq);
		free(RQ->ctmp1);
		CALL_SHELL_FN(RQ, SHELL_INT_NO_COMP);
	}
	RQ->ctmp2 = RQ->u.mrq.ptr;
	l = strlen(RQ->u2.rddir_rq.entries[0]->d_name);
	for (i = 1; i < RQ->itmp7; i++) {
		for (j = 0; j < l; j++) {
			if (__unlikely(RQ->u2.rddir_rq.entries[i]->d_name[j] != RQ->u2.rddir_rq.entries[i - 1]->d_name[j])) {
				l = j;
				break;
			}
		}
	}
	q = stpcpy(RQ->ctmp2, RQ->vtmp1);
	memcpy(q, RQ->u2.rddir_rq.entries[0]->d_name, l);
	q[l] = 0;
	if (__unlikely(RQ->itmp7 > 1)) {
		RQ->scratch_2[0] = 0;
		RQ->u.ioctlrq.fn = SHELL_INT_COMP_LS_CHECK2;
		RQ->u.ioctlrq.h = RQ->ctty_in;
		RQ->u.ioctlrq.ioctl = IOCTL_TTY_NTAB;
		RQ->u.ioctlrq.param = 0;
		RQ->u.ioctlrq.v.ptr = 0;
		RQ->u.ioctlrq.v.len = 0;
		RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
		RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
	}
	RQ->u.openrq.fn = SHELL_INT_COMP_OPEN;
	RQ->u.openrq.path = RQ->ctmp2;
	RQ->u.openrq.cwd = RQ->cwd;
	RQ->u.openrq.flags = _O_NOACCESS | _O_NOWAIT;
	RETURN_IORQ_CANCELABLE(&RQ->u.openrq, KERNEL$OPEN, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_OPEN, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.openrq.status < 0)) {
		RQ->scratch_2[0] = ' ';
		CALL_SHELL_FN(RQ, SHELL_INT_COMPL_QUOTE_ARG);
	}
	RQ->u.ioctlrq.fn = SHELL_INT_COMP_STAT;
	RQ->u.ioctlrq.h = RQ->u.openrq.status;
	RQ->u.ioctlrq.ioctl = IOCTL_STAT;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->stat;
	RQ->u.ioctlrq.v.len = sizeof(struct stat);
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_STAT, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	KERNEL$FAST_CLOSE(RQ->u.ioctlrq.h);
	if (__unlikely(RQ->u.ioctlrq.status < 0) || __likely(!S_ISDIR(RQ->stat.st_mode))) RQ->scratch_2[0] = ' ';
	else RQ->scratch_2[0] = '/';
	CALL_SHELL_FN(RQ, SHELL_INT_COMPL_QUOTE_ARG);
}

static DECL_AST(SHELL_INT_COMPL_QUOTE_ARG, SPL_SHELL, CTX)
{
	char *p, *q;
	int i, l, qq;
	unsigned char c;
	l = strlen(RQ->ctmp2);
	p = RQ->ctmp2 + __alloc_size(RQ->ctmp2) - l - 1;
	memmove(p, RQ->ctmp2, l + 1);
	q = RQ->ctmp2;
	qq = 0;
	for (; (c = *p); p++) {
		if (__likely(!qq)) {
			if (__unlikely(c == '"')) {
				*q++ = '\'';
				*q++ = '"';
				qq = '\'';
				continue;
			}
			if (__unlikely(c == '\'') || __unlikely(c == '%') || __unlikely(c == ';') || __unlikely(c == ',') || __unlikely(c == '=') || __unlikely(c <= ' ') || __unlikely(GLOBCHAR(c))) {
				*q++ = '"';
				*q++ = c;
				qq = '"';
				continue;
			}
			*q++ = c;
			continue;
		} else if (__unlikely(qq == '\'')) {
			if (__unlikely(c == '\'') || __unlikely(c == '%')) {
				*q++ = '\'';
				*q++ = '"';
				*q++ = c;
				qq = '"';
				continue;
			}
			*q++ = c;
			continue;
		} else {
			if (__unlikely(c == '"')) {
				*q++ = '"';
				*q++ = '\'';
				*q++ = '"';
				qq = '\'';
				continue;
			}
			*q++ = c;
			continue;
		}
	}
	if (__unlikely(qq)) *q++ = qq;
	if (__likely(RQ->scratch_2[0])) *q++ = RQ->scratch_2[0];
	*q = 0;
	for (i = 0; (c = RQ->ctmp2[i]); i++) {
		if (__unlikely(c == '\'') || __unlikely(c == '"')) {
			memmove(RQ->ctmp2 + 1, RQ->ctmp2, i);
			RQ->ctmp2[0] = c;
			break;
		}
	}
	__upcase(RQ->ctmp2);
	if (1 || __likely(RQ->scratch_2[0])) CALL_SHELL_FN(RQ, SHELL_INT_COMPL_PUSH1);
	if (__unlikely(RQ->ctty_err < 0)) CALL_SHELL_FN(RQ, SHELL_INT_COMPL_PUSH1);
	RQ->u.siorq.fn = SHELL_INT_COMPL_PUSH1;
	RQ->u.siorq.h = RQ->ctty_err;
	RQ->u.siorq.v.ptr = (unsigned long)"\007";
	RQ->u.siorq.v.len = 1;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMPL_PUSH1, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	intx = RQ->intx;
	RQ->u.ioctlrq.fn = SHELL_INT_COMPL_PUSH2;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)(intx->buf + RQ->itmp1 + 1);
	RQ->u.ioctlrq.v.len = intx->buf_ptr - RQ->itmp1 - 1;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMPL_PUSH2, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	RQ->u.ioctlrq.fn = SHELL_INT_COMPL_PUSH3;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)RQ->ctmp2;
	RQ->u.ioctlrq.v.len = strlen(RQ->ctmp2);
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMPL_PUSH3, SPL_SHELL, CTX)
{
	INTX *intx;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	free(RQ->ctmp1);
	free(RQ->ctmp2);
	KERNEL$FREE_READDIR(&RQ->u2.rddir_rq);
	intx = RQ->intx;
	RQ->u.ioctlrq.fn = SHELL_INT_COMPL_CLR_2T;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_PUTBACK;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)intx->buf;
	RQ->u.ioctlrq.v.len = RQ->itmp3;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMPL_CLR_2T, SPL_SHELL, CTX)
{
	if (__unlikely(!RQ->scratch_2[0])) CALL_SHELL_FN(RQ, SHELL_INT_PUTBACK);
	RQ->u.ioctlrq.fn = SHELL_INT_PUTBACK;
	RQ->u.ioctlrq.h = RQ->ctty_in;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_NTAB;
	RQ->u.ioctlrq.param = 1;
	RQ->u.ioctlrq.v.ptr = 0;
	RQ->u.ioctlrq.v.len = 0;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_LS_CHECK2, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__likely(RQ->u.ioctlrq.status != 2) || __unlikely(RQ->ctty_err < 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_COMPL_QUOTE_ARG);
	}
	RQ->u.ioctlrq.fn = SHELL_INT_COMP_LS_WINSIZE;
	RQ->u.ioctlrq.h = RQ->ctty_err;
	RQ->u.ioctlrq.ioctl = IOCTL_TTY_GET_WINSIZE;
	RQ->u.ioctlrq.param = 0;
	RQ->u.ioctlrq.v.ptr = (unsigned long)&RQ->winsize;
	RQ->u.ioctlrq.v.len = sizeof RQ->winsize;
	RQ->u.ioctlrq.v.vspace = &KERNEL$VIRTUAL;
	RETURN_IORQ_CANCELABLE(&RQ->u.ioctlrq, KERNEL$IOCTL, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_LS_WINSIZE, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.ioctlrq.status < 0)) RQ->winsize.ws_col = 1;
	if (__unlikely(RQ->winsize.ws_col > SCRATCH_1_LEN)) RQ->winsize.ws_col = SCRATCH_1_LEN;
	RQ->u.mrq.fn = SHELL_INT_COMP_LS_ALLOC_COL;
	RQ->u.mrq.size = (RQ->winsize.ws_col / 3) * sizeof(int);
	RETURN_IORQ_CANCELABLE(&RQ->u.mrq, KERNEL$UNIVERSAL_MALLOC, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_LS_ALLOC_COL, SPL_SHELL, CTX)
{
	unsigned c, r;
	unsigned i, w;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.mrq.status < 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_COMPL_QUOTE_ARG);
	}
	RQ->ptmp1 = RQ->u.mrq.ptr;
	c = RQ->winsize.ws_col / 3;
	ac:
	if (c <= 1) {
		c = 1;
		r = RQ->itmp7;
		goto skp;
	}
	r = (RQ->itmp7 + c - 1) / c;
	memset(RQ->ptmp1, 0, c * sizeof(int));
	for (i = 0; i < RQ->itmp7; i++) {
		unsigned l = strlen(RQ->u2.rddir_rq.entries[i]->d_name) + 2;
		unsigned idx = i / r;
		if (l > RQ->ptmp1[idx]) RQ->ptmp1[idx] = l;
	}
	w = 0;
	for (i = 0; i < c; i++) w += RQ->ptmp1[i];
	if (w - 2 > RQ->winsize.ws_col) {
		c--;
		goto ac;
	}
	skp:
	RQ->itmp4 = c;
	RQ->itmp5 = r;
	RQ->itmp6 = 0;
	RQ->u.siorq.fn = SHELL_INT_COMP_LS_WRITE;
	RQ->u.siorq.h = RQ->ctty_err;
	RQ->u.siorq.v.ptr = (unsigned long)"\n";
	RQ->u.siorq.v.len = 1;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_LS_WRITE, SPL_SHELL, CTX)
{
	unsigned i, j, o, k;
	char *str, *sstr;
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->itmp6 >= RQ->itmp5)) {
		CALL_SHELL_FN(RQ, SHELL_INT_COMP_LS_DONE);
	}
	if (__unlikely(RQ->itmp4 == 1)) {
		RQ->u.siorq.fn = SHELL_INT_COMP_LS_WROTE;
		RQ->u.siorq.h = RQ->ctty_err;
		RQ->u.siorq.v.ptr = (unsigned long)RQ->u2.rddir_rq.entries[RQ->itmp6]->d_name;
		RQ->u.siorq.v.len = strlen(RQ->u2.rddir_rq.entries[RQ->itmp6]->d_name);
		RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
		RQ->u.siorq.progress = 0;
		RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
	}
	i = RQ->itmp6;
	j = 0;
	o = 0;
	again:
	sstr = str = RQ->u2.rddir_rq.entries[i]->d_name;
	while (o < SCRATCH_1_LEN && *str) RQ->scratch_1[o++] = *str++;
	i += RQ->itmp5;
	if (i < RQ->itmp7) {
		for (k = strlen(sstr); k < RQ->ptmp1[j]; k++) if (__likely(o < SCRATCH_1_LEN)) RQ->scratch_1[o++] = ' ';
		j++;
		goto again;
	}
	RQ->u.siorq.fn = SHELL_INT_COMP_LS_WROTE;
	RQ->u.siorq.h = RQ->ctty_err;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
	RQ->u.siorq.v.len = o;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_LS_WROTE, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.siorq.status <= 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_COMP_LS_DONE);
	}
	if (__unlikely(RQ->u.siorq.v.len)) {
		RQ->u.siorq.progress = 0;
		RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
	}
	RQ->u.siorq.fn = SHELL_INT_COMP_LS_WROTE_2;
	RQ->u.siorq.h = RQ->ctty_err;
	RQ->u.siorq.v.ptr = (unsigned long)"\n";
	RQ->u.siorq.v.len = 1;
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_LS_WROTE_2, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.siorq.status <= 0)) {
		CALL_SHELL_FN(RQ, SHELL_INT_COMP_LS_DONE);
	}
	RQ->itmp6++;
	CALL_SHELL_FN(RQ, SHELL_INT_COMP_LS_WRITE);
}

static DECL_AST(SHELL_INT_COMP_LS_DONE, SPL_SHELL, CTX)
{
	free(RQ->ptmp1);
	MAKE_PROMPT(RQ);
	RQ->u.siorq.fn = SHELL_INT_COMP_WROTE_PROMPT;
	RQ->u.siorq.h = RQ->ctty_out;
	RQ->u.siorq.v.ptr = (unsigned long)RQ->scratch_1;
	RQ->u.siorq.v.len = strlen(RQ->scratch_1);
	RQ->u.siorq.v.vspace = &KERNEL$VIRTUAL;
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, KERNEL$WRITE, RQ->p->rq);
}

static DECL_AST(SHELL_INT_COMP_WROTE_PROMPT, SPL_SHELL, CTX)
{
	IO_DISABLE_CHAIN_CANCEL(SPL_X(SPL_SHELL), RQ->p->rq);
	if (__unlikely(RQ->u.siorq.status <= 0) || __likely(!RQ->u.siorq.v.len)) CALL_SHELL_FN(RQ, SHELL_INT_COMPL_QUOTE_ARG);
	RQ->u.siorq.progress = 0;
	RETURN_IORQ_CANCELABLE(&RQ->u.siorq, &KERNEL$WRITE, RQ->p->rq);
}

