#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <SPAD/LIBC.H>
#include <SPAD/DL.H>

#include "SHELL.H"

void SHELL_ASSIGN_COMMAND(CTX *ctx)
{
	int r;
	const char * const *argv = (const char * const *)ctx->argv;
	int state = 0;
	int flags = 0;
	char *name = NULL;
	char *alias = NULL;
	static const struct __param_table params[9] = {
		"PUBLIC", __PARAM_BOOL, LNTE_PUBLIC, LNTE_PUBLIC,
		"PRIVATE", __PARAM_BOOL, LNTE_PUBLIC, 0,
		"BLOCK_IF_NOT_FOUND", __PARAM_BOOL, LNTE_BLOCK_IF_NOT_FOUND, LNTE_BLOCK_IF_NOT_FOUND,
		"DONT_BLOCK_IF_NOT_FOUND", __PARAM_BOOL, LNTE_BLOCK_IF_NOT_FOUND, 0,
		"FILE_SHARE", __PARAM_BOOL, LNTE_FILE_SHARE, LNTE_FILE_SHARE,
		"NO_FILE_SHARE", __PARAM_BOOL, LNTE_FILE_SHARE, 0,
		"", __PARAM_STRING, 1, -1,
		"", __PARAM_STRING, 1, -1,
		NULL, 0, 0, 0,
	};
	void *vars[9];
	vars[0] = &flags;
	vars[1] = &flags;
	vars[2] = &flags;
	vars[3] = &flags;
	vars[4] = &flags;
	vars[5] = &flags;
	vars[6] = &alias;
	vars[7] = &name;
	vars[8] = NULL;
	if (__unlikely(__parse_params(&argv, &state, params, vars, NULL, NULL, NULL)) || __unlikely(!name) || __unlikely(!alias)) {
		_snprintf(ctx->return_msg, __MAX_STR_LEN, "ASSIGN: SYNTAX ERROR");
		ctx->return_val = -EBADSYN;
		return;
	}
	r = MTX_LOCK_SYNC_CANCELABLE(&KERNEL$DMAN_MUTEX);
	if (__unlikely(r < 0)) {
		if (r != -EINTR); _snprintf(ctx->return_msg, __MAX_STR_LEN, "ASSIGN: CAN'T LOCK");
		ctx->return_val = r;
		return;
	}
	ctx->return_val = KERNEL$CREATE_LOGICAL(name, alias, flags);
	if (__unlikely(ctx->return_val < 0)) {
		if (ctx->return_val != -EINTR) _snprintf(ctx->return_msg, __MAX_STR_LEN, "ASSIGN: %s (%s <- %s)", strerror(-ctx->return_val), alias, name);
	} else {
		*ctx->return_msg = 0;
	}
	MTX_UNLOCK(&KERNEL$DMAN_MUTEX);
	return;
}

void SHELL_DEASSIGN_COMMAND(CTX *ctx)
{
	int r;
	const char * const *argv = (const char * const *)ctx->argv;
	int state = 0;
	int block = 0;
	char *name = NULL;
	static const struct __param_table params[3] = {
		"BLOCK", __PARAM_BOOL, ~0, LN_DELETE_LOGICAL_BLOCK,
		"", __PARAM_STRING, 1, -1,
		NULL, 0, 0, 0,
	};
	void *vars[3];
	vars[0] = &block;
	vars[1] = &name;
	vars[2] = NULL;
	if (__unlikely(__parse_params(&argv, &state, params, vars, NULL, NULL, NULL)) || __unlikely(!name)) {
		_snprintf(ctx->return_msg, __MAX_STR_LEN, "DEASSIGN: SYNTAX ERROR");
		ctx->return_val = -EBADSYN;
		return;
	}
	r = MTX_LOCK_SYNC_CANCELABLE(&KERNEL$DMAN_MUTEX);
	if (__unlikely(r < 0)) {
		if (r != -EINTR); _snprintf(ctx->return_msg, __MAX_STR_LEN, "DEASSIGN: CAN'T LOCK");
		ctx->return_val = r;
		return;
	}
	r = KERNEL$DELETE_LOGICAL(name, block);
	if (__unlikely(r)) {
		_snprintf(ctx->return_msg, __MAX_STR_LEN, "DEASSIGN: %s (%s)", strerror(-r), name);
		ctx->return_val = r;
	}
	MTX_UNLOCK(&KERNEL$DMAN_MUTEX);
	return;
}

void SHELL_SETLOGICAL_COMMAND(CTX *ctx)
{
	int r;
	const char * const *argv = (const char * const *)ctx->argv;
	int state = 0;
	int flags = 0;
	int flags_chg_mask = 0;
	char *name = NULL;
	static const struct __param_table params[10] = {
		"PUBLIC", __PARAM_BOOL, LNTE_PUBLIC, LNTE_PUBLIC,
		"PUBLIC", __PARAM_BOOL, LNTE_PUBLIC, LNTE_PUBLIC,
		"PRIVATE", __PARAM_BOOL, LNTE_PUBLIC, 0,
		"PRIVATE", __PARAM_BOOL, LNTE_PUBLIC, LNTE_PUBLIC,
		"BLOCK_IF_NOT_FOUND", __PARAM_BOOL, LNTE_BLOCK_IF_NOT_FOUND, LNTE_BLOCK_IF_NOT_FOUND,
		"BLOCK_IF_NOT_FOUND", __PARAM_BOOL, LNTE_BLOCK_IF_NOT_FOUND, LNTE_BLOCK_IF_NOT_FOUND,
		"DONT_BLOCK_IF_NOT_FOUND", __PARAM_BOOL, LNTE_BLOCK_IF_NOT_FOUND, 0,
		"DONT_BLOCK_IF_NOT_FOUND", __PARAM_BOOL, LNTE_BLOCK_IF_NOT_FOUND, LNTE_BLOCK_IF_NOT_FOUND,
		"", __PARAM_STRING, 1, -1,
		NULL, 0, 0, 0,
	};
	void *vars[10];
	vars[0] = &flags;
	vars[1] = &flags_chg_mask;
	vars[2] = &flags;
	vars[3] = &flags_chg_mask;
	vars[4] = &flags;
	vars[5] = &flags_chg_mask;
	vars[6] = &flags;
	vars[7] = &flags_chg_mask;
	vars[8] = &name;
	vars[9] = NULL;
	if (__unlikely(__parse_params(&argv, &state, params, vars, NULL, NULL, NULL)) || __unlikely(!name)) {
		_snprintf(ctx->return_msg, __MAX_STR_LEN, "SETLOGICAL: SYNTAX ERROR");
		ctx->return_val = -EBADSYN;
		return;
	}
	r = MTX_LOCK_SYNC_CANCELABLE(&KERNEL$DMAN_MUTEX);
	if (__unlikely(r < 0)) {
		if (r != -EINTR); _snprintf(ctx->return_msg, __MAX_STR_LEN, "SETLOGICAL: CAN'T LOCK");
		ctx->return_val = r;
		return;
	}
	ctx->return_val = KERNEL$SET_LOGICAL(name, flags, flags_chg_mask, NULL, NULL, NULL);
	if (__unlikely(ctx->return_val < 0)) {
		_snprintf(ctx->return_msg, __MAX_STR_LEN, "SETLOGICAL: %s (%s)", strerror(-ctx->return_val), name);
	} else {
		*ctx->return_msg = 0;
	}
	MTX_UNLOCK(&KERNEL$DMAN_MUTEX);
	return;
}

