#ifndef __VGA_VGA_H
#define __VGA_VGA_H

#include <SPAD/TTY.H>

extern struct tty_videomode mode_param;
extern unsigned max_y;
extern int current_mode;

extern int vt_active;
extern unsigned graph_mem_len;
extern unsigned save_restore_memory;
extern unsigned current_page;

#define can_omit_draw   __unlikely(!(vt_active | save_restore_memory))

extern unsigned accel_in_progress;
int accel_do_manually(unsigned op, union accel_param *ap);

void mouse_setmode(int gfx, int x, int y);
extern int mouse_handle;

extern int ignore_1_mouse_event;

extern unsigned pixel_clock;
extern unsigned hh;
extern unsigned h_sync_start;
extern unsigned h_sync_end;
extern unsigned h_total;
extern unsigned vv;
extern unsigned v_sync_start;
extern unsigned v_sync_end;
extern unsigned v_total;
extern unsigned timing_flags;

void get_timing(int x, int y, int bpp);

#endif
