#include <SPAD/DEV.H>
#include <SPAD/SYNC.H>
#include <SPAD/WQ.H>
#include <SPAD/DL.H>

#include "DMAN.H"

#define CMD_UNLOAD	1
#define CMD_RESET	2
static char command;

#define R_RESET		1
#define R_HALT		2
#define R_POWEROFF	3
static char reset;

int main(int argc, char *argv[])
{
	int r, i;
	DEVICE *d;

	r = MTX_LOCK_SYNC_CANCELABLE(&KERNEL$DMAN_MUTEX);
	if (__unlikely(r < 0)) {
		if (r != -EINTR) _snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "DMAN: CAN'T LOCK: %s", strerror(-r));
		goto ret0;
	}

	if (__unlikely(argc < 2)) {
		bads:
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "DMAN: BAD SYNTAX");
		r = -EBADSYN;
		goto ret1;
	}
	if (!_strcasecmp(argv[1], "UNLOAD")) command = CMD_UNLOAD;
	else if (!_strcasecmp(argv[1], "RESET")) command = CMD_RESET, reset = R_RESET;
	else if (!_strcasecmp(argv[1], "HALT")) command = CMD_RESET, reset = R_HALT;
	else if (!_strcasecmp(argv[1], "POWEROFF")) command = CMD_RESET, reset = R_POWEROFF;
	else goto bads;

	r = BUILD_DEVICE_DATABASE();
	if (__unlikely(r)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "DMAN: CAN'T BUILD DEVICE DATABASE: %s", strerror(-r));
		goto ret1;
	}

	r = CHECK_LOOPS();
	if (__unlikely(r)) {
		_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "DMAN: DEPENDENCY GRAPH HAS LOOPS");
		goto ret2;
	}

	if (command == CMD_UNLOAD) {
		for (i = 2; i < argc; i++) {
			const char *error;
			d = FIND_DEVICE(argv[i], &error);
			if (!d) {
				_snprintf(KERNEL$ERROR_MSG(), __MAX_STR_LEN, "%s: %s", argv[i], error);
				r = -ENOENT;
				goto ret2;
			}
			DFS(d, 0, DFS_MARK);
		}
		/*for (i = 0; i < HASH_SIZE; i++) XLIST_FOR_EACH(d, &DEVICE_HASH[i], DEVICE, hash_list) {
			if (d->process_flag) _printf("%s\n", d->name);
		}*/
		r = UNLOAD_MARKED();
	} else if (command == CMD_RESET) {
		for (i = 0; i < HASH_SIZE; i++) XLIST_FOR_EACH(d, &DEVICE_HASH[i], DEVICE, hash_list) {
			d->process_flag = 1;
		}
		r = UNLOAD_MARKED();
		if (r) reset = R_HALT;
		if (reset == R_RESET) RESET();
		if (reset == R_POWEROFF) POWEROFF();
		else HALT();
	} else {
		KERNEL$SUICIDE("DMAN: UNKNOWN COMMAND %d", (int)command);
	}

	ret2:
	DROP_DEVICE_DATABASE();
	ret1:
	MTX_UNLOCK(&KERNEL$DMAN_MUTEX);
	ret0:
	return r;
}
