#ifndef __DMAN_DMAN_H
#define __DMAN_DMAN_H

#include <SPAD/LIST.H>
#include <SPAD/DEV.H>
#include <SPAD/TIMER.H>

#define UNLOAD_TIMEOUT	(JIFFIES_PER_SECOND * 15)

typedef struct __unrq UNRQ;
typedef struct __device DEVICE;
typedef struct __dependency DEPENDENCY;

struct __device {
	LIST_ENTRY hash_list;
	LIST_ENTRY walk_list;
	XLIST_HEAD using_head;
	XLIST_HEAD used_head;
	int flags;
	char walk_flag;
	char process_flag;
	char state;
	char skip_links;

	LIST_ENTRY processing_list;
	union {
		DCTLRQ dctlrq;
	} rq;

	char name[1];
};

#define LNTE_NOT_LOADED		(LNTE_PARENT - 1)

#define STATE_LOADED		0
#define STATE_UNLOADED		1
#define STATE_UNLOADING		3

struct __dependency {
	LIST_ENTRY used_list;
	DEVICE *used;
	LIST_ENTRY using_list;
	DEVICE *using;
};

/* DMANDB.C */

#define HASH_SIZE	256

extern XLIST_HEAD DEVICE_HASH[HASH_SIZE];

int BUILD_DEVICE_DATABASE(void);
void DROP_DEVICE_DATABASE(void);
DEVICE *FIND_DEVICE(const char *name, const char **error);

/* DMANDFS.C */

#define WALK_REVERSE	1
int DFS(DEVICE *d, int flags, int (*test_new)(DEVICE *d));
int DFS_MARK(DEVICE *d);

/* DMANLOOP.C */

int CHECK_LOOPS(void);

/* DMANLOAD.C */

int UNLOAD_MARKED(void);

/* DMANRST.C */

void RESET(void);
void HALT(void);
void POWEROFF(void);

#endif
