#include <ERRNO.H>
#include <SPAD/LIST.H>
#include <SPAD/LIBC.H>

#include "DMAN.H"

int DFS(DEVICE *d, int flags, int (*process)(DEVICE *d))
{
	int r;

	DEVICE *dep_dev;
	DEPENDENCY *dep;

	DECL_XLIST(pending_devs);
	DECL_XLIST(finished_devs);

	if (!d) {
		int i;
		for (i = 0; i < HASH_SIZE; i++) XLIST_FOR_EACH(d, &DEVICE_HASH[i], DEVICE, hash_list) {
			if (!(flags & WALK_REVERSE) ? XLIST_EMPTY(&d->using_head) : XLIST_EMPTY(&d->used_head)) {
				d->walk_flag = 1;
				ADD_TO_XLIST(&pending_devs, &d->walk_list);
			}
		}
		goto pop_next;
	}

	ADD_TO_XLIST(&pending_devs, &d->walk_list);
	d->walk_flag = 2;

	again:

	if (!(flags & WALK_REVERSE)) {
		XLIST_FOR_EACH(dep, &d->used_head, DEPENDENCY, used_list) {
			dep_dev = dep->using;
			new_device:

			if (dep_dev->walk_flag <= 2) {
				if (dep_dev->walk_flag == 2) {
					r = -ELOOP;
					goto cleanup_ret;
				}
				if (dep_dev->walk_flag == 1) {
					DEL_FROM_LIST(&dep_dev->walk_list);
				}
				ADD_TO_XLIST(&pending_devs, &dep_dev->walk_list);
				dep_dev->walk_flag = 1;
			}

			if (flags & WALK_REVERSE) goto reverse_cycle;
		}
	} else {
		XLIST_FOR_EACH(dep, &d->using_head, DEPENDENCY, using_list) {
			dep_dev = dep->used;
			goto new_device;
			reverse_cycle:;
		}
	}
	pop_next:
	if (!XLIST_EMPTY(&pending_devs)) {
		d = LIST_STRUCT(pending_devs.next, DEVICE, walk_list);
		d->walk_flag++;
		if (d->walk_flag == 2) {
			goto again;
		} else {
			if (process) {
				r = process(d);
				if (__unlikely(r)) goto cleanup_ret;
			}
			DEL_FROM_LIST(&d->walk_list);
			ADD_TO_XLIST(&finished_devs, &d->walk_list);
			goto pop_next;
		}
	}

	r = 0;

	cleanup_ret:
	XLIST_FOR_EACH(d, &pending_devs, DEVICE, walk_list) d->walk_flag = 0;
	XLIST_FOR_EACH(d, &finished_devs, DEVICE, walk_list) d->walk_flag = 0;

	return r;
}

int DFS_MARK(DEVICE *d)
{
	d->process_flag = 1;
	return 0;
}

