#include <SPAD/SYSLOG.H>
#include <SPAD/TIMER.H>

#include "DMAN.H"

static const char * const null_argv[1] = { NULL };

static DECL_XLIST(unloading);
static DECL_LIST(unloaded);
static WQ_DECL(unloaded_wq, "DMAN$UNLOAD_WQ");

static AST_STUB UNLOADED;

static void TRY_UNLOAD(DEVICE *d)
{
	DEPENDENCY *dep;
	if (!d->process_flag)
		return;
	if (d->state != STATE_LOADED)
		return;
	XLIST_FOR_EACH(dep, &d->used_head, DEPENDENCY, used_list) {
		if (dep->using->state != STATE_UNLOADED) return;
	}
	RAISE_SPL(SPL_SHELL);
	if (d->flags == LNTE_PARENT || d->flags == LNTE_NOT_LOADED) {
		*d->rq.dctlrq.error = 0;
		d->rq.dctlrq.status = 0;
		ADD_TO_LIST_END(&unloaded, &d->processing_list);
		goto lower_ret;
	}
	/*__debug_printf("unloading: %s.  ", d->name);*/
	if (!(d->flags & LNTE_DEVICE)) {
		d->rq.dctlrq.status = KERNEL$DELETE_LOGICAL(d->name, 0);
		if (d->rq.dctlrq.status) _snprintf(d->rq.dctlrq.error, sizeof d->rq.dctlrq.error, "%s", strerror(-d->rq.dctlrq.status));
		else *d->rq.dctlrq.error = 0;
		ADD_TO_LIST_END(&unloaded, &d->processing_list);
		goto lower_ret;
	}
	d->state = STATE_UNLOADING;
	d->rq.dctlrq.unload = 1;
	d->rq.dctlrq.name = d->name;
	d->rq.dctlrq.argv = null_argv;
	d->rq.dctlrq.cwd = NULL;
	d->rq.dctlrq.std_in = -1;
	d->rq.dctlrq.std_out = -1;
	d->rq.dctlrq.std_err = -1;
	d->rq.dctlrq.fn = UNLOADED;
	ADD_TO_XLIST(&unloading, &d->processing_list);
	CALL_IORQ(&d->rq.dctlrq, KERNEL$DCTL);
	lower_ret:
	LOWER_SPL(SPL_ZERO);
}

static DECL_AST(UNLOADED, SPL_SHELL, DCTLRQ)
{
	DEVICE *d = GET_STRUCT(RQ, DEVICE, rq.dctlrq);
	/*__debug_printf("done: %s.  ", d->name);*/
	DEL_FROM_LIST(&d->processing_list);
	ADD_TO_LIST_END(&unloaded, &d->processing_list);
	WQ_WAKE_ALL_PL(&unloaded_wq);
	RETURN;
}

static void PRINT_UNLOADING(void)
{
	int first = 1;
	DEVICE *d;
	__critical_printf("UNLOADING: ");
	XLIST_FOR_EACH(d, &unloading, DEVICE, processing_list) {
		__critical_printf("%s%s", first ? "" : ", ", d->name);
		first = 0;
	}
	__critical_printf("\n");
}

static void WAKE_UNLOADED_WQ(TIMER *t)
{
	LOWER_SPL(SPL_TIMER);
	WQ_WAKE_ALL_PL(&unloaded_wq);
	KERNEL$SET_TIMER(UNLOAD_TIMEOUT, t);
}

static DEVICE *GET_UNLOADED(int *error)
{
	u_jiffies_lo_t j;
	DEVICE *d;
	RAISE_SPL(SPL_SHELL);
	again:
	j = KERNEL$GET_JIFFIES_LO();
	while (LIST_EMPTY(&unloaded)) {
		DECL_TIMER(t);
		if (__unlikely(XLIST_EMPTY(&unloading))) {
			LOWER_SPL(SPL_ZERO);
			return NULL;
		}
		if (__unlikely(KERNEL$GET_JIFFIES_LO() - j >= UNLOAD_TIMEOUT)) {
			PRINT_UNLOADING();
			goto again;
		}
		t.fn = WAKE_UNLOADED_WQ;
		KERNEL$SET_TIMER(UNLOAD_TIMEOUT, &t);
		WQ_WAIT_SYNC(&unloaded_wq);
		KERNEL$DEL_TIMER(&t);
	}
	d = LIST_STRUCT(unloaded.next, DEVICE, processing_list);
	DEL_FROM_LIST(&d->processing_list);
	if (__unlikely(d->rq.dctlrq.status < 0)) {
		KERNEL$SYSLOG(__SYSLOG_SW_ERROR, "DMAN", "UNABLE TO UNLOAD DEVICE %s: %s", d->name, d->rq.dctlrq.error);
		d->state = STATE_LOADED;
		if (!*error) *error = d->rq.dctlrq.status;
		goto again;
	}
	d->state = STATE_UNLOADED;
	LOWER_SPL(SPL_ZERO);
	return d;
}

int UNLOAD_MARKED(void)
{
	int error = 0;
	DEVICE *d;
	DEPENDENCY *dep;
	int i;
	for (i = 0; i < HASH_SIZE; i++) XLIST_FOR_EACH(d, &DEVICE_HASH[i], DEVICE, hash_list) TRY_UNLOAD(d);
	while ((d = GET_UNLOADED(&error))) {
		XLIST_FOR_EACH(dep, &d->using_head, DEPENDENCY, using_list)
			TRY_UNLOAD(dep->used);
	}
	return error;
}

