#include <SPAD/LIST.H>
#include <SPAD/LIBC.H>
#include <ERRNO.H>

#include "DMAN.H"

int CHECK_LOOPS(void)
{
	int i;
	DEVICE *d;
	if (__unlikely(DFS(NULL, 0, DFS_MARK))) return -ELOOP;
	for (i = 0; i < HASH_SIZE; i++) XLIST_FOR_EACH(d, &DEVICE_HASH[i], DEVICE, hash_list) {
		if (__unlikely(!d->process_flag)) return -ELOOP;
		d->process_flag = 0;
	}
	return 0;
}
