#ifndef __SPAD__
#define __CROSS_COMPILING_LINKER
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <bfd.h>
#include <errno.h>
#include <values.h>
#ifdef __offsetof
#undef __offsetof
#endif
#define __offsetof(type, field) ((size_t)(&((type *)0)->field))
static inline void __barrier(void) {}
#else
#include <STDIO.H>
#include <STDLIB.H>
#include <UNISTD.H>
#include <SYS/TYPES.H>
#include <SYS/STAT.H>
#include <FCNTL.H>
#include <STRING.H>
#include <BFD.H>
#include <ERRNO.H>
#include <VALUES.H>
#endif

#include "INCLUDE/MD5.H"
#include "INCLUDE/SHA.H"
#include "INCLUDE/RIPEMD.H"
#include "INCLUDE/SHA256.H"

#include "INCLUDE/SPAD/LINK.H"
#include "INCLUDE/SPAD/LIST.H"

#ifndef __SPAD__
LIST_ENTRY KERNEL$LIST_END;
#endif

#define DEBUG

#ifdef DEBUG
#define debug(x) printf x, fflush(stdout)
#else
#define debug(x)
#endif

#if defined(__EMX__) && !defined(__SPAD__)
#define strcasecmp stricmp
#define strncasecmp strnicmp
#define write __write
#define read __read
#endif

char *cplus_demangle(char *, int);

#define DMGL_NO_OPTS	0		/* For readability... */
#define DMGL_PARAMS	(1 << 0)	/* Include function args */
#define DMGL_ANSI	(1 << 1)	/* Include const, volatile, etc */
#define DMGL_JAVA	(1 << 2)	/* Demangle as Java rather than C++. */
#define DMGL_VERBOSE	(1 << 3)	/* Include implementation details.	*/
#define DMGL_TYPES	(1 << 4)	/* Also try to demangle type encodings.	*/

#define DMGL_AUTO	(1 << 8)
#define DMGL_GNU	(1 << 9)
#define DMGL_LUCID	(1 << 10)
#define DMGL_ARM	(1 << 11)
#define DMGL_HP		(1 << 12)	/* For the HP aCC compiler;
					   same as ARM except for
					   template arguments, etc. */
#define DMGL_EDG	(1 << 13)
#define DMGL_GNU_V3	(1 << 14)
#define DMGL_GNAT	(1 << 15)


#if 0
Apply this patch to binutils-2.14 to get nested archives working correctly.
Without it, binutils crashes

--- bfd/archive.c_	Wed Apr 21 19:28:07 2004
+++ bfd/archive.c	Wed Apr 21 20:54:25 2004
@@ -498,6 +498,11 @@
   struct areltdata *new_areldata;
   bfd *n_nfd;
 
+  if (archive->my_archive) {
+    filepos += archive->origin;
+    archive = archive->my_archive;
+  }
+
   n_nfd = _bfd_look_for_bfd_in_cache (archive, filepos);
   if (n_nfd)
     return n_nfd;
@@ -593,6 +598,7 @@
 	 BSD-4.4-style element with a long odd size.  */
       filestart = last_file->origin + size;
       filestart += filestart % 2;
+      if (archive->my_archive) filestart -= archive->origin;
     }
 
   return _bfd_get_elt_at_filepos (archive, filestart);
#endif

static void *x_malloc(size_t s)
{
	void *p = malloc(s);
	if (!p && s) {
		fprintf(stderr, "out of memory for malloc(%lu)\n", (unsigned long)s);
		exit(1);
	}
	return p;
}

static void *x_realloc(void *p, size_t s)
{
	p = realloc(p, s);
	if (!p && s) {
		fprintf(stderr, "out of memory for realloc(%lu)\n", (unsigned long)s);
		exit(1);
	}
	return p;
}

static int multiply(size_t s1, size_t s2)
{
	if (s1 >= MAXINT || s2 >= MAXINT || (s1 && s2 >= MAXINT / s1)) {
		fprintf(stderr, "allocation overflow, attempting to allocate %lu*%lu bytes\n", (unsigned long)s1, (unsigned long)s2);
		exit(1);
	}
	return s1 * s2;
}

static void *x_salloc(size_t s1, size_t s2)
{
	return x_malloc(multiply(s1, s2));
}

static void *x_srealloc(void *p, size_t s1, size_t s2)
{
	return x_realloc(p, multiply(s1, s2));
}

static char *do_demangle(char *str)
{
	char *dmg, *x;
	char *s = strchr(str, ':');
	if (!s) s = str;
	else s++;
	dmg = cplus_demangle(s, 0);
	if (!dmg) return str;
	if (s == str) return dmg;
	x = x_malloc(s - str + strlen(dmg) + 1);
	memcpy(x, str, s - str);
	strcpy(x + (s - str), dmg);
	return x;
}

#define SYMBOL_HASH_SIZE 4096

static char **jmp_symbols = NULL;
static int n_jmp_symbols = 0;
static char *force_dynamic;
static unsigned link_flags;

struct lib_int {
	LIST_ENTRY e;
	char *name;
	unsigned flags;
	int n_syms;
	char **syms;
	struct link_symbol **ls;
};

static LIST_HEAD interfaces;

static struct lib_int *out_interface;
static struct link_symbol **out_syms = NULL;

static char **ignore_out_syms = NULL;
static int n_ignore_out_syms = 0;

static char *i_start = "_START";

static struct lib_int default_out_interface = {
	{ NULL, NULL },
	"IMG",
	0,
	1,
	&i_start,
};

static char *i_dev_start = "_START";

static struct lib_int dev_out_interface = {
	{ NULL, NULL },
	"DEV",
	0,
	1,
	&i_dev_start,
};

static struct lib_int empty_out_interface = {
	{ NULL, NULL },
	NULL,
	0,
	0,
	NULL,
};

static XLIST_HEAD global_symbol_hash[SYMBOL_HASH_SIZE];
static XLIST_HEAD common_symbol_hash[SYMBOL_HASH_SIZE];
static XLIST_HEAD extern_symbol_hash[SYMBOL_HASH_SIZE];
static XLIST_HEAD got_symbol_hash[SYMBOL_HASH_SIZE];

static LIST_HEAD common_symbols;

static char **libpath;
static int libpath_n;

static bfd *archive_list_start, *archive_list_end;
char **archive_filenames;
int *archive_l;
int n_archives;

static LIST_HEAD spad_sections;

struct spad_section {
	LIST_ENTRY e;
	char **link_sections;
	int n_link_sections;
	LIST_HEAD *secs;
	int num;
	__f_off size;
	int align;
	__f_off offset;
	__f_off address;
	char name[1];
};

struct link_symbol {
	LIST_ENTRY e;
	LIST_ENTRY se;
	asymbol *s;
	struct spad_subsection *sect;
	struct spad_section *ssect;
	__f_off ssect_off;
	char exported;

	struct lib_int *interface;	/* used only in extern_symbol_hash */
	int interface_index;		/*		""		*/
	int used;			/*		""		*/

	long com_size;			/* used only in common_symbol_hash */
	struct link_symbol *shadow;	/*		""		*/
	LIST_ENTRY ce;			/*		""		*/

	char name[1];
};

struct spad_subsection {
	LIST_ENTRY e;
	asection *sect;
	long n_bfd_rels;
	arelent **bfd_rels;
	struct spad_section *s;
	__f_off offset;
	__f_off size;
	int align;
	void *contents;
	struct link_symbol sect_sym;
};

#define REL_PC	1
#define REL_GOT	2

struct patch {
	LIST_ENTRY e;
	LIST_ENTRY u;
	struct spad_subsection *sec;
	struct link_symbol *symbol;
	__f_off address;
	int howto_pcrel_offset;
	__f_off special_offset;
	char *sym_name;
};

struct link_file {
	bfd *b;
	asymbol **syms;
	int n_syms;
	char name[1];
};

static struct spad_subsection spad_abs_subsection;
static struct spad_section spad_abs_section_[2];
#define spad_abs_section (spad_abs_section_[0])

static struct spad_subsection got;

static LIST_HEAD patches;
static LIST_HEAD unresolved_patches;
static LIST_HEAD extern_patches;

static char *bfdformat;
static char *symfile;

static char *output_header;
static long output_len;

static int out_handle;

static unsigned long reloc = 0;

static int add_section(char *spadsec, char *sec);
static void addstr(char ***s, int *l, char *str, int copy);

static void link_init(void)
{
	int i;
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) INIT_XLIST(&global_symbol_hash[i]);
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) INIT_XLIST(&common_symbol_hash[i]);
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) INIT_XLIST(&extern_symbol_hash[i]);
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) INIT_XLIST(&got_symbol_hash[i]);
	link_flags = 0;
	INIT_LIST(&interfaces);
	out_interface = NULL;
	INIT_LIST(&common_symbols);
	INIT_LIST(&spad_sections);
	INIT_LIST(&patches);
	INIT_LIST(&unresolved_patches);
	INIT_LIST(&extern_patches);
	add_section(".TEXT", NULL);
	add_section(".RODATA", NULL);
	add_section(".DATA", NULL);
	add_section(".BSS", NULL);
	libpath = NULL;
	libpath_n = 0;
	archive_list_start = archive_list_end = NULL;
	archive_filenames = NULL;
	archive_l = NULL;
	n_archives = 0;
	bfdformat = /*"elf32-i386"*/NULL;
	memset(&spad_abs_subsection, 0, sizeof spad_abs_subsection);
	memset(&spad_abs_section, 0, sizeof spad_abs_section);
	spad_abs_section.num = -1;
	strcpy(spad_abs_section.name, ".ABS");
	spad_abs_subsection.sect_sym.sect = &spad_abs_subsection;
	spad_abs_subsection.sect_sym.ssect = &spad_abs_section;
	memset(&got, 0, sizeof got);
	got.sect_sym.sect = &got;
	output_header = NULL;
	output_len = 0;
}

static void upcase(char *p)
{
	while (*p) {
		if (*p >= 'a' && *p <= 'z') *p -= 'a' - 'A';
		p++;
	}
}

static void locase(char *p)
{
	while (*p) {
		if (*p >= 'A' && *p <= 'Z') *p += 'a' - 'A';
		p++;
	}
}

static int hash_name(char *name)
{
	int i, h = 0;
	for (i = 0; name[i]; i++) h = (h << 1) + h + name[i] - (name[i] >= 'a' && name[i] <= 'z' ? 'a' - 'A' : 0);
	return h & (SYMBOL_HASH_SIZE - 1);
}

static void insert_symbol(XLIST_HEAD *symbol_hash, struct link_symbol *s)
{
	ADD_TO_XLIST(&symbol_hash[hash_name(s->name)], &s->e);
}

static struct link_symbol *lookup_symbol(XLIST_HEAD *symbol_hash, char *name)
{
	struct link_symbol *s;
	XLIST_FOR_EACH(s, &symbol_hash[hash_name(name)], struct link_symbol, e)
		if (!strcmp(s->name, name)) return s;
	return NULL;
}

static void addstr(char ***s, int *l, char *str, int copy)
{
	if (*l == MAXINT) {
		fprintf(stderr, "array size overflow\n");
		exit(1);
	}
	*s = x_srealloc(*s, (*l + 1), sizeof(char *));
	(*s)[(*l)++] = copy ? strcpy(x_malloc(strlen(str) + 1), str) : str;
}

static void addint(int **s, int *l, int i)
{
	(*s = x_srealloc(*s, (*l + 1), sizeof(int)))[*l] = i;
	(*l)++;
}

static int add_section(char *spadsec, char *sec)
{
	int i;
	struct spad_section *s;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		if (!strcasecmp(s->name, spadsec)) return 1;
		if (sec) for (i = 0; i < s->n_link_sections; i++) {
			if (!strcasecmp(s->link_sections[i], sec)) return 1;
		}
	}
	s = x_malloc(sizeof(struct spad_section) + strlen(spadsec) + 1);
	s->secs = NULL;
	if (sec) {
		s->link_sections = x_malloc(sizeof(char *));
		*s->link_sections = x_malloc(strlen(sec) + 1);
		strcpy(*s->link_sections, sec);
		s->n_link_sections = 1;
	} else {
		s->link_sections = NULL;
		s->n_link_sections = 0;
	}
	strcpy(s->name, spadsec);
	upcase(s->name);
	ADD_TO_LIST_END(&spad_sections, &s->e);
	return 0;
}

static int add_subsection(char *spadsec, char *sec)
{
	int i;
	struct spad_section *s, *ss = NULL;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		if (!strcasecmp(s->name, spadsec)) ss = s;
		if (sec) for (i = 0; i < s->n_link_sections; i++) {
			if (!strcasecmp(s->link_sections[i], sec)) return 1;
		}
	}
	if (!ss) return 1;
	addstr(&ss->link_sections, &ss->n_link_sections, sec, 1);
	upcase(ss->link_sections[ss->n_link_sections - 1]);
	return 0;
}

static void add_default_subsections(int tx, int ro, int dt, int bs)
{
	struct spad_section *s;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		if (s->n_link_sections) continue;
		if (tx && !strcasecmp(s->name, ".TEXT")) {
			add_subsection(s->name, ".TEXT");
			add_subsection(s->name, ".GNU.LINKONCE.T");
		} else if (ro && !strcasecmp(s->name, ".RODATA")) {
			add_subsection(s->name, ".RODATA");
			add_subsection(s->name, ".GNU.LINKONCE.R");
			add_subsection(s->name, ".CTORS");
			add_subsection(s->name, ".DTORS");
			add_subsection(s->name, ".GCC_EXCEPT_TABLE");
			add_subsection(s->name, ".EH_FRAME");
			add_subsection(s->name, ".FEATURE_FIXUP");
		} else if (dt && !strcasecmp(s->name, ".DATA")) {
			add_subsection(s->name, ".DATA");
			add_subsection(s->name, ".GNU.LINKONCE.D");
		} else if (bs && !strcasecmp(s->name, ".BSS")) {
			add_subsection(s->name, ".BSS");
			add_subsection(s->name, ".GNU.LINKONCE.B");
		}
	}
}

static void add_archive(char *name, bfd *a, int l)
{
	int na;
	bfd *aa;
	for (aa = archive_list_start; aa; aa = aa->usrdata) if (aa == a) return;
	if (archive_list_end) {
		archive_list_end->usrdata = a;
		archive_list_end = a;
		a->usrdata = NULL;
	} else (archive_list_start = archive_list_end = a)->usrdata = NULL;
	na = n_archives;
	addstr(&archive_filenames, &n_archives, name, 1);
	addint(&archive_l, &na, l);
}

static int is_forced_dynamic(char *name, char **str, size_t *len)
{
	int testlib = 0;
	char *fd;
	size_t namelen;
	char *n = strrchr(name, '/');
	if (n) name = n + 1;
	namelen = strlen(name);
	if (namelen > 2 && !strcasecmp(name + namelen - 2, ".A")) namelen -= 2;
	if (namelen > 3 && !strncasecmp(name, "LIB", 3)) testlib = 1;
	fd = force_dynamic;
	if (!fd) return 0;
	do {
		size_t p = strcspn(fd, ",");
		if (p) {
			if (p == 1 && fd[0] == '*') return 1;
			if (p == namelen && !strncasecmp(fd, name, namelen)) {
				*str = name;
				*len = namelen;
				return 1;
			}
			if (testlib && p == namelen - 3 && !strncasecmp(fd, name + 3, namelen - 3)) {
				*str = name + 3;
				*len = namelen - 3;
				return 1;
			}
		}
		fd += p;
	} while (*fd++);
	return 0;
}

static char *find_file(char *name, char *prepend, char *append, int *order)
{
	int i;
	struct stat st;
	if (strchr(name, '/')) {
		if (!access(name, R_OK) && !stat(name, &st) && S_ISREG(st.st_mode)) {
			*order = -1;
			return strcpy(x_malloc(strlen(name) + 1), name);
		}
		return NULL;
	}
	retry:
	for (i = 0; i < libpath_n; i++) {
		char *x, *y, *p;
		*order = i;
		p = x_malloc(strlen(libpath[i]) + 1 + strlen(prepend) + strlen(name) + strlen(append) + 1);
		strcpy(p, libpath[i]);
		strcat(p, "/");
		x = p + strlen(p);
		strcpy(x, prepend);
		strcat(x, name);
		strcat(x, append);
		if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
		upcase(x);
		if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
		locase(x);
		if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
		strcpy(x, prepend);
		locase(x);
		strcat(x, name);
		y = x + strlen(x);
		strcpy(y, append);
		locase(y);
		if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
		if (*prepend) {
			strcpy(p, libpath[i]);
			strcat(p, "/");
			strcat(p, name);
			y = p + strlen(p);
			strcpy(y, append);
			if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
			upcase(y);
			if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
			locase(y);
			if (!access(p, R_OK) && !stat(p, &st) && S_ISREG(st.st_mode)) return p;
		}
		free(p);
	}
	if (!access(name, R_OK) && !stat(name, &st) && S_ISREG(st.st_mode)) {
		*order = MAXINT;
		return strcpy(x_malloc(strlen(name) + 1), name);
	}
	if (strchr(name, '.') && (*prepend | *append)) {
		prepend = append = "";
		goto retry;
	}
	return NULL;
}

static char *filename_base(char *f, int ext)
{
	char *e, *r, *p = strrchr(f, '/');
	if (!p) p = strrchr(f, ':');
	if (!p) p = f;
	else p++;
	if (ext || !(e = strrchr(p, '.'))) e = p + strlen(p);
	r = x_malloc(e - p + 1);
	memcpy(r, p, e - p);
	r[e - p] = 0;
	return r;
}

static int is_special(char *name)
{
	if (name[0] != 'D' && name[0] != '_') return 0;
	return	!strcmp(name, "DLL$LOAD") ||
		!strcmp(name, "DLL$UNLOAD") ||
		!strcmp(name, "_init") ||
		!strcmp(name, "_fini") ||
		!strcmp(name, "DLL$EFS") ||
		!strcmp(name, "DLL$EFE") ||
		!strcmp(name, "DLL$FIXUP") ||
		!strcmp(name, "DLL$FIXUP_END") ||
		!strcmp(name, "DLL$CTORS") ||
		!strcmp(name, "DLL$CTORS_END") ||
		!strcmp(name, "DLL$DTORS") ||
		!strcmp(name, "DLL$DTORS_END");
}

static int compare_string(const void *p1, const void *p2)
{
	return strcmp(*(char **)p1, *(char **)p2);
}

static void free_interface(struct lib_int *in)
{
	int i;
	for (i = 0; i < in->n_syms; i++) free(in->syms[i]);
	free(in->syms);
	free(in->name);
	if (in->ls) free(in->ls);
	free(in);
}

static struct lib_int *load_interface(char *file, int read_dll, int sort, int add_ign)
{
	char r[LINK_DYNAMIC_SYMBOL_NAME_LEN + 1];
	struct lib_int *in = NULL;
	FILE *f;
	if (!(f = fopen(file, "r"))) goto ret;
	in = x_malloc(sizeof(struct lib_int));
	memset(in, 0, sizeof(struct lib_int));
	in->name = filename_base(file, 0);
	upcase(in->name);
	if (!read_dll) while (fgets(r, sizeof r, f)) {
		char *q;
		r[sizeof r - 1] = 0;
		if (strlen(r) == sizeof r - 1) {
			del:
			free_interface(in);
			in = NULL;
			goto ret_cl;
		}
		for (q = r; *q; q++) if ((unsigned char)*q < ' ' && *q != '\n' && *q != '\r' && *q != '\t') goto del;
		if ((q = strchr(r, '\n'))) *q = 0;
		if ((q = strchr(r, '\r'))) *q = 0;
		while (*r == ' ' || *r == '\t') memmove(r, r + 1, strlen(r));
		if ((q = strchr(r, ' '))) *q = 0;
		if ((q = strchr(r, '\t'))) *q = 0;
		if (!*r || *r == ';') {
			continue;
		}
		q = r;
		if (*q == '-') {
			q++;
			if (add_ign)
				addstr(&ignore_out_syms, &n_ignore_out_syms, q, 1);
		}
		/*if (is_special(r)) goto del;*/
		addstr(&in->syms, &in->n_syms, q, 1);
	} else {
		unsigned i;
		struct link_header lh;
		fpos_t fp;
		if (fread(&lh, sizeof lh, 1, f) != 1) goto del;
		if (lh.lnk_id != LNK_ID || lh.lnk_ver != LNK_VER) goto del;
		fp = lh.lib_name;
		if (fsetpos(f, &fp)) goto del;
		if (!fgets(r, sizeof r, f)) goto del;
		if (*r) {
			free(in->name);
			in->name = x_malloc(strlen(r) + 1);
			strcpy(in->name, r);
			upcase(in->name);
		}
		for (i = 0; i < lh.n_exported_syms; i++) {
			struct sym sym;
			fp = lh.syms + (__f_off)i * sizeof(struct sym);
			if (fsetpos(f, &fp)) goto del;
			if (fread(&sym, sizeof sym, 1, f) != 1) goto del;
			fp = sym.name;
			if (fsetpos(f, &fp)) goto del;
			if (!fgets(r, sizeof r, f)) goto del;
			addstr(&in->syms, &in->n_syms, r, 1);
		}
	}
	if (sort) qsort(in->syms, in->n_syms, sizeof(char *), compare_string);
	in->ls = x_salloc(sizeof(struct link_symbol *), in->n_syms);
	memset(in->ls, 0, sizeof(struct link_symbol *) * in->n_syms);
	ret_cl:
	fclose(f);
	ret:
	return in;
}

/* 0 --- dynamic .int
   1 --- dynamic .dll
   2 --- static
*/

static int guess_type(char *file, int do_open)
{
	/* Attempt to determine what we really got */
	union {
		struct link_header lh;
		char p[1];
	} u;
	int r;
	FILE *f;
	char *dot = strrchr(file, '.');
	if (dot && !strpbrk(dot, "/:")) {
		if (!strcasecmp(dot, ".INT")) return 0;
		if (!strcasecmp(dot, ".DLL")) return 1;
		if (!strcasecmp(dot, ".A")) return 2;
	}
	if (!do_open) return -1;
	memset(&u, 0, sizeof u);
	f = fopen(file, "r");
	if (!f) return -1;
	r = fread(&u, 1, sizeof u, f);
	fclose(f);
	if (!strcmp(u.p, "!<arch>")) return 0;
	if (r == sizeof u && u.lh.lnk_id == LNK_ID && u.lh.lnk_ver == LNK_VER) return 1;
	return 2;
}

/*
 * st == 1	--- prefer static
 * st == 0	--- prefer dynamic
 * st == -1	--- lazy library
 * st == -2	--- only dynamic, do not print error
 */

static int load_library(char *name, int st)
{
	int r;
	int type;
	struct lib_int *li, *lli;
	int order;
	char *file = NULL;
	int order1;
	char *file1 = NULL;
	file = find_file(name, "", ".INT", &order);
	file1 = find_file(name, "", ".DLL", &order1);
	if (file1 && (!file || order1 < order)) {
		if (file) free(file);
		file = file1;
		order = order1;
		file1 = NULL;
	}
	if (file1) free(file1);
	if (st >= 0 && (!file || !is_forced_dynamic(name, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END))) {
		file1 = find_file(name, "LIB", ".A", &order1);
		if (file1 && (!file || order1 < order || (order1 == order && st == 1))) {
			if (file) free(file);
			file = file1;
			order = order1;
			file1 = NULL;
		}
		if (file1) free(file1);
	}
	if (!file) {
		if (st != -2) fprintf(stderr, "library `%s' not found\n", name);
		r = -1;
		goto ret;
	}
	type = guess_type(file, 1);
	if (type == 2) {
		bfd *b;
		b = bfd_openr(file, bfdformat);
		if (!b) {
			bfd_perror(name);
			r = -2;
			goto ret;
		}
		if (!bfd_check_format(b, bfd_archive) && !bfd_check_format(b, bfd_object)) {
			bfd_perror(name);
			r = -2;
			goto ret;
		}
		add_archive(file, b, 1);
		file = NULL;	/* pointer passed to bfd_openr must be active */
	} else {
		int i;
		if (!(li = load_interface(file, type == 1, 1, 0))) {
			fprintf(stderr, "could not load interface file `%s'\n", file);
			r = -2;
			goto ret;
		}
		LIST_FOR_EACH(lli, &interfaces, struct lib_int, e) {
			if (!strcmp(lli->name, li->name)) {
				if (st != -1) lli->flags &= ~LIB_LAZY;
				free_interface(li);
				goto ret0;
			}
		}
		if (st == -1) li->flags |= LIB_LAZY;
		ADD_TO_LIST_END(&interfaces, &li->e);
		for (i = 0; i < li->n_syms; i++) {
			struct link_symbol *sym;
			if ((sym = lookup_symbol(extern_symbol_hash, li->syms[i]))) {
				continue;
				/*
				fprintf(stderr, "duplicate symbol `%s' in interfaces `%s' and `%s'\n", do_demangle(li->syms[i]), sym->interface->name, li->name);
				r = -2;
				goto ret;
				*/
			}
			sym = x_malloc(sizeof(struct link_symbol) + strlen(li->syms[i]) + 1);
			memset(sym, 0, sizeof(struct link_symbol));
			sym->interface = li;
			sym->interface_index = i;
			strcpy(sym->name, li->syms[i]);
			insert_symbol(extern_symbol_hash, sym);
			li->ls[i] = sym;
		}
	}
	ret0:
	r = 0;
	ret:
	if (file) free(file);
	return r;
}

static void prepare_sections(void)
{
	struct spad_section *s;
	int i;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		if (!strcmp(s->name, ".TEXT")) {
			s->link_sections = x_srealloc(s->link_sections, (s->n_link_sections + 1), sizeof(char *));
			memmove(s->link_sections + 1, s->link_sections, (s->n_link_sections++) * sizeof(char *));
			s->link_sections[0] = "";
		}
		s->secs = x_salloc(s->n_link_sections, sizeof(LIST_HEAD));
		for (i = 0; i < s->n_link_sections; i++) INIT_LIST(&s->secs[i]);
		if (!strcmp(s->name, ".TEXT")) {
			ADD_TO_LIST(&s->secs[0], &got.e);
			got.align = 1;
			got.s = s;
		}
	}
}

#include <TOOLS/LINKA.I>

static __f_off get_got_entry(char *sym, int plt)
{
	struct link_symbol *ls = lookup_symbol(got_symbol_hash, sym);
	if (ls != NULL) goto ret;
	ls = x_malloc(sizeof(struct link_symbol) + strlen(sym) + 1);
	strcpy(ls->name, sym);
	arch_insert_gotplt_entry(ls);
	ret:
	return arch_get_gotplt_offset(ls, plt);
}

static int section_match(const char *objsec, const char *spadsec)
{
	int l;
	if (!strcasecmp(objsec, spadsec)) return 0;
	l = strlen(spadsec);
	if (!l) return 1;
	if (!strncasecmp(objsec, spadsec, l) && objsec[l] == '.') return 0;
	return 1;
}

static int is_section_linkonce(bfd *b, asection *s)
{
	if (!strncasecmp(bfd_get_section_name(b, s), ".GNU.LINKONCE.", strlen(".GNU.LINKONCE."))) return 1;
	return 0;
}

static int load_object(bfd *b, char *name, int get_all)
{
	static XLIST_HEAD symhash[SYMBOL_HASH_SIZE];
	struct spad_section *s;
	int i;
	asection *sect;
	struct link_file *lf;
	long sym_space;

	for (i = 0; i < SYMBOL_HASH_SIZE; i++) INIT_XLIST(&symhash[i]);

	lf = x_malloc(sizeof(struct link_file) + strlen(name) + 1);
	lf->b = b;
	strcpy(lf->name, name);

	for (sect = b->sections; sect; sect = sect->next) sect->userdata = NULL;

	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) for (i = 0; i < s->n_link_sections; i++) for (sect = b->sections; sect; sect = sect->next) if (!section_match(bfd_get_section_name(b, sect), s->link_sections[i])) {
		struct spad_subsection *ls;
		if (sect->userdata) continue;
		sect->userdata = ls = x_malloc(sizeof(struct spad_subsection));
		memset(ls, 0, sizeof(struct spad_subsection));
		ls->sect = sect;
		ls->s = s;
		ls->align = 1 << bfd_get_section_alignment(b, sect);
		ls->size = bfd_section_size(b, sect);
		ADD_TO_LIST_END(&s->secs[i], &ls->e);
	}

	sym_space = bfd_get_symtab_upper_bound(b);
	if (sym_space < 0) {
		bfd_perror("bfd_get_symtab_upper_bound");
		return -1;
	}
	if (!sym_space) {
		lf->syms = NULL;
		lf->n_syms = 0;
	} else {
		lf->syms = x_malloc(sym_space);
		if ((lf->n_syms = bfd_canonicalize_symtab(lf->b, lf->syms)) < 0) {
			bfd_perror("bfd_canonicalize_symtab");
			return -1;
		}
	}

	for (i = 0; i < lf->n_syms; i++) {
		asymbol *s = lf->syms[i];
		char *name = (char *)s->name;
		struct link_symbol *sym, *x;
		if (s->flags & (BSF_SECTION_SYM | BSF_INDIRECT | BSF_FILE)) continue;
		if (s->flags & BSF_LOCAL) {
			char *fnb = x_malloc(strlen(lf->name) + 1);
			strcpy(fnb, lf->name);
			upcase(fnb);
			strcpy(name = x_malloc(strlen(fnb) + strlen(s->name) + 2), fnb);
			strcat(name, ":");
			strcat(name, s->name);
			free(fnb);
		}
		/*fprintf(stderr, "Sym %s file %s value %08x\n", name, lf->name, (unsigned)s->value);*/
		if (s->section == &bfd_abs_section) ;
		else if (s->section == &bfd_com_section) ;
		else if (s->section == &bfd_und_section) goto e;
		else {
			for (sect = b->sections; sect; sect = sect->next) if (s->section == sect) {
				if (!sect->userdata) goto e;
				goto found;
			}
			goto e;
		}
		found:
		sym = x_malloc(sizeof(struct link_symbol) + strlen(name) + 1);
		memset(sym, 0, sizeof(struct link_symbol));
		sym->s = s;
		strcpy(sym->name, name);
		if (s->section == &bfd_com_section) {
			sym->com_size = s->value;
			if ((x = lookup_symbol(common_symbol_hash, name))) {
				if (x->com_size > sym->com_size) x->com_size = sym->com_size;
				avoid_duplicates:
				free(sym);
			} else {
				insert_symbol(common_symbol_hash, sym);
				ADD_TO_LIST_END(&common_symbols, &sym->ce);
				goto add_to_local_symhash;
			}
		} else {
			if (lookup_symbol(global_symbol_hash, name)) {
				char *colon;
				if (is_section_linkonce(b, s->section)) goto avoid_duplicates;
				if ((colon = strchr(name, ':'))) {
					char *newname;
					char *c;
					for (c = colon; c > name; c--) if (c[-1] < '0' || c[-1] > '9') break;
					if (c > name && c[-1] == '.' && c[0] != ':') {
						unsigned long n = atol(c) + 1;
						newname = x_malloc(strlen(name) + 1 + 1);
						sprintf(newname, "%.*s%ld%s", (int)(c - name), name, n, colon);
						if (strlen(newname) > strlen(name) + 1) {
							fprintf(stderr, "internal: shot to memory: old name \"%s\" (%ld), new name \"%s\" (%ld)\n", name, (unsigned long)strlen(name), newname, (unsigned long)strlen(newname));
							abort();
						}
					} else {
						newname = x_malloc(strlen(name) + 3);
						memcpy(newname, name, colon - name);
						memcpy(newname + (colon - name), ".1", 2);
						strcpy(newname + (colon - name) + 2, colon);
					}
					/*fprintf(stderr, "mangle: \"%s\" -> \"%s\"\n", name, newname);*/
					if (name != s->name) free(name);
					free(sym);
					name = newname;
					goto found;
				}
				if (!get_all)
					fprintf(stderr, "duplicate symbol: `%s'\n", do_demangle(name));
				return -1;
			}
			if (s->section == &bfd_abs_section) sym->sect = &spad_abs_subsection, sym->ssect = &spad_abs_section;
			else sym->sect = sect->userdata, sym->ssect = ((struct spad_subsection *)sect->userdata)->s;
			insert_symbol(global_symbol_hash, sym);
			add_to_local_symhash:
			ADD_TO_XLIST(&symhash[((int)s + (int)s / SYMBOL_HASH_SIZE) & (SYMBOL_HASH_SIZE - 1)], &sym->se);
		}

		e:
		if (name != s->name) free(name);
	}

	for (sect = b->sections; sect; sect = sect->next) {
		struct spad_subsection *ls;
		long relsize;
		if (!(ls = sect->userdata)) continue;
		relsize = bfd_get_reloc_upper_bound(b, sect);
		if (relsize < 0) {
			bfd_perror("bfd_get_reloc_upper_bound");
			return -1;
		}
		ls->bfd_rels = x_malloc(relsize);
		if ((ls->n_bfd_rels = bfd_canonicalize_reloc(b, sect, ls->bfd_rels, lf->syms)) < 0) {
			bfd_perror("bfd_canonicalize_reloc");
			return -1;
		}
		for (i = 0; i < ls->n_bfd_rels; i++) {
			int plt;
			struct link_symbol *sym;
			asymbol *s;
			arelent *r = ls->bfd_rels[i];
			const struct reloc_howto_struct *h = r->howto;
			struct patch *pt;

			/*fprintf(stderr, "reloc: %s %d %x\n", h->name, h->pcrel_offset, r->address);*/
			if (bfd_get_reloc_size(h) != 4 || h->rightshift || h->bitsize != 32 || h->bitpos || h->src_mask != 0xFFFFFFFF || h->dst_mask != 0xFFFFFFFF) {
				fprintf(stderr, "unknown relocation\n");
				fprintf(stderr, "rel: %08x, sect: %s, sym: %s, flags: %08x\n", (int)r->address, ls->sect->name, (*r->sym_ptr_ptr)->name, (*r->sym_ptr_ptr)->flags);
				fprintf(stderr, "type: %s, rightshift: %d, size: %d, bfd_get_reloc_size: %d, bitsize: %d, pc_relative: %d, bitpos: %d, special: %p, name: %s, inplace: %d, src_mask: %016llx, dst_mask: %016llx, pcrel_off: %d\n", bfd_get_reloc_code_name(h->type), h->rightshift, h->size, bfd_get_reloc_size(h), h->bitsize, (int)h->pc_relative, h->bitpos, h->special_function, h->name, (int)h->partial_inplace, (long long)h->src_mask, (long long)h->dst_mask, (int)h->pcrel_offset);
				return -1;
			}
			pt = x_malloc(sizeof(struct patch));
			pt->special_offset = 0;
			/*pt->relent = r;*/
			pt->address = r->address;
			pt->howto_pcrel_offset = r->howto->pcrel_offset ? REL_PC : 0;
			pt->sym_name = (char *)(*r->sym_ptr_ptr)->name;
			pt->sec = ls;
			if (!strcmp(pt->sym_name, "_GLOBAL_OFFSET_TABLE_")) {
				pt->symbol = &got.sect_sym;
				goto ok;
			}
			if (strstr(h->name, "GOTOFF")) {
				if (pt->howto_pcrel_offset) {
					fprintf(stderr, "GOTOFF PCREL reloc of `%s'\n", pt->sym_name);
					return -1;
				}
				pt->howto_pcrel_offset = REL_GOT;
				goto proc_sym;
			}
			plt = 0;
			if (strstr(h->name, "PLT32")) plt = 1;
			if (plt || strstr(h->name, "GOT32")) {
				/*fprintf(stderr, "%s at %p\n", h->name, pt->address);*/
				pt->special_offset = get_got_entry(pt->sym_name, plt);
				pt->symbol = plt ? &got.sect_sym : &spad_abs_subsection.sect_sym;
				goto ok;
			}
			proc_sym:
			s = *r->sym_ptr_ptr;
			if (s->flags & BSF_SECTION_SYM) {
				asection *sec = s->section, *secc;
				if (sec == &bfd_abs_section) {
					pt->symbol = &spad_abs_subsection.sect_sym;
					goto ok;
				}
				for (secc = b->sections; secc; secc = secc->next) if (secc == sec) {
					if (sec->userdata) goto f;
					fprintf(stderr, "reloc against unlinked section `%s'\n", sec->name);
					return -1;
				}
				goto undef_sym;
				f:
				pt->symbol = &(((struct spad_subsection *)sec->userdata)->sect_sym);
				goto ok;
			}
			XLIST_FOR_EACH(sym, &symhash[((int)s + (int)s / SYMBOL_HASH_SIZE) & (SYMBOL_HASH_SIZE - 1)], struct link_symbol, se) if (sym->s == s) {
				pt->symbol = sym;
				goto ok;
			}
			undef_sym:
			pt->symbol = NULL;
			ADD_TO_LIST_END(&unresolved_patches, &pt->u);
			ok:
			ADD_TO_LIST_END(&patches, &pt->e);
		}
	}
	return 0;
}

static struct link_symbol *resolve_name(char *name)
{
	struct link_symbol *sym;
	sym = lookup_symbol(global_symbol_hash, name);
	if (sym) return sym;
	sym = lookup_symbol(common_symbol_hash, name);
	if (sym) return sym;
	sym = lookup_symbol(extern_symbol_hash, name);
	return sym;
}

static void export_symbol(struct link_symbol *sym)
{
	if (strchr(sym->name, ':')) return;
	addstr(&out_interface->syms, &out_interface->n_syms, sym->name, 0);
}

static char **unresolved = NULL;
static int unresolved_n = 0;
static int unresolved_nonnull;

static int resolve_patches(void)
{
	int i;
	struct patch *pt, *ptt;
	if (unresolved) free(unresolved), unresolved = NULL;
	unresolved_n = 0;
	LIST_FOR_EACH(pt, &unresolved_patches, struct patch, u) {
		char *name = pt->sym_name;
		struct link_symbol *sym = resolve_name(name);
		if (sym) {
			ptt = LIST_STRUCT(pt->u.prev, struct patch, u);
			DEL_FROM_LIST(&pt->u);
			if (sym->interface) {
				ADD_TO_LIST(&extern_patches, &pt->u);
				addstr(&unresolved, &unresolved_n, name, 0);
			} else {
				pt->symbol = sym;
			}
			pt = ptt;
		} else {
			addstr(&unresolved, &unresolved_n, name, 0);
		}
	}
	for (i = 0; i < out_interface->n_syms; i++) if (!out_syms[i]) {
		struct link_symbol *sym = resolve_name(out_interface->syms[i]);
		if (sym) {
			if (sym->interface) {
				fprintf(stderr, "symbol `%s' in both input and output interface\n", out_interface->syms[i]);
				return -1;
			}
			out_syms[i] = sym;
			sym->exported = 1;
		} else {
			addstr(&unresolved, &unresolved_n, out_interface->syms[i], 0);
		}
	}
	unresolved_nonnull = unresolved_n;
	return 0;
}

static int squash_missing_out_syms(void)
{
	int i, j;
	for (i = 0; i < out_interface->n_syms; i++) if (!out_syms[i]) {
		for (j = 0; j < n_ignore_out_syms; j++) if (!strcmp(ignore_out_syms[j], out_interface->syms[i])) {
			free(out_interface->syms[i]);
			memmove(&out_interface->syms[i], &out_interface->syms[i + 1], (out_interface->n_syms - i - 1) * sizeof(char *));
			out_interface->n_syms--;
			return 1;
		}
	}
	return 0;
}

static int are_there_unresolved(void)
{
	int i;
	if (!LIST_EMPTY(&unresolved_patches)) return 1;
	for (i = 0; i < out_interface->n_syms; i++) if (!out_syms[i]) return 1;
	return 0;
}

static int resolve_extern_patches(void)
{
	struct patch *pt, *ptt;
	LIST_FOR_EACH(pt, &extern_patches, struct patch, u) {
		char *name = pt->sym_name;
		struct link_symbol *sym = resolve_name(name);
		if (!sym) {
			fprintf(stderr, "internal: symbol `%s' was resolved in previous passes but was unresolved in final pass\n", name);
			abort();
		}
		pt->symbol = sym;
		ptt = LIST_STRUCT(pt->u.prev, struct patch, u);
		DEL_FROM_LIST(&pt->u);
		pt = ptt;
	}
	return 0;
}

static int check_if_usable(char *afilename, bfd *b, int get_all)
{
	int load = 0;
	int i, j, k;
	char *name;
	long sym_space;
	asymbol **syms;
	long n_syms;
	if (!bfd_check_format(b, bfd_object)) {
		if (bfd_check_format(b, bfd_archive)) {
			name = x_malloc(strlen(afilename) + 1 + strlen(b->filename) + 1);
			strcpy(name, afilename);
			strcat(name, "/");
			strcat(name, b->filename);
			add_archive(name, b, get_all ? 0 : 1);
			free(name);
			return 0;
		}
		return 0;
	}
	sym_space = bfd_get_symtab_upper_bound(b);
	if (sym_space < 0) {
		bfd_perror("bfd_get_symtab_upper_bound");
		return -1;
	}
	if (!sym_space) return 0;

	syms = x_malloc(sym_space);
	if ((n_syms = bfd_canonicalize_symtab(b, syms)) < 0) {
		bfd_perror("bfd_canonicalize_symtab");
		return -1;
	}

	if (get_all) load = 1;
	else for (i = 0; i < n_syms; i++) {
		asymbol *s = syms[i];
		if (s->flags & (BSF_SECTION_SYM | BSF_INDIRECT | BSF_FILE | BSF_LOCAL)) continue;
		for (j = 0; j < unresolved_n; j++) if (unresolved[j] && !strcmp(unresolved[j], s->name)) {
			struct spad_section *ss;
			if (s->section == &bfd_abs_section || s->section == &bfd_com_section) goto sec_ok;
			LIST_FOR_EACH(ss, &spad_sections, struct spad_section, e) for (k = 0; k < ss->n_link_sections; k++) {
				if (!section_match(bfd_get_section_name(b, s->section), ss->link_sections[k])) goto sec_ok;
			}
			break;
			sec_ok:
			unresolved[j] = NULL;
			unresolved_nonnull--;
			load = 1;
		}
	}
	if (!load) return 0;
	name = x_malloc(strlen(afilename) + 1 + strlen(b->filename) + 1);
	strcpy(name, afilename);
	strcat(name, "/");
	strcat(name, b->filename);
	if (load_object(b, name, get_all)) return -1;
	free(name);
	return 1;
}

static int search_archives(int get_all)
{
	int i;
	int o = 0;
	bfd *a;
	for (a = archive_list_start, i = 0; a; a = a->usrdata, i++) {
		bfd *b;
		if (archive_l[i] < 0) continue;
		if (get_all && archive_l[i]) continue;
		b = NULL;
		while (bfd_check_format(a, bfd_object) ? (b = a) : (b = bfd_openr_next_archived_file(a, b))) {
			int s = check_if_usable(archive_filenames[i], b, get_all);
			if (s < 0) return -1;
			if (s > 0) o = 1;
			if (!unresolved_nonnull && !get_all) return 1;
			if (bfd_check_format(a, bfd_object)) break;
		}
	}
	return o;
}

static void write_header(void *data, long len)
{		/* idea by Karel Kulhavy (clock) from links browser */
	long nl;
	if (!len) return;
	nl = output_len + len;
	if ((nl ^ output_len) >= output_len) {
		long nll = nl;
		nll |= nll >> 1;
		nll |= nll >> 2;
		nll |= nll >> 4;
		nll |= nll >> 8;
		nll |= nll >> 16;
		if (sizeof(long) > 4) nll |= nll >> 31 >> 1;
		output_header = x_realloc(output_header, nll + 1);
	}
	memcpy(output_header + output_len, data, len);
	output_len += len;
}

static void align_header(void)
{
	char zero[LINK_ALIGN];
	memset(zero, 0, LINK_ALIGN);
	write_header(zero, LINK_ALIGN - 1 - ((output_len + LINK_ALIGN - 1) % LINK_ALIGN));
}

static __f_off align_offset(__f_off off, int align)
{
	return (off + align - 1) & ~((__f_off)align - 1);
}

static int common_align(struct link_symbol *ls)
{
	long cs = ls->com_size;
	return cs < 2 ? 1 : cs < 4 ? 2 : cs < 8 ? 4 : cs < 16 ? 8 : 16;
}

static int total_symbols;
static int special_symbols;

static int prepare_output(void)
{
	int i;
	int has_com, bss_proc;
	int sal;
	struct spad_section *s;
	struct lib_int *li, *lii;
	struct link_symbol *ls;
	struct patch *p;
	LIST_FOR_EACH(p, &patches, struct patch, e) {
		p->symbol->used = 1;
	}
	LIST_FOR_EACH(li, &interfaces, struct lib_int, e) {
		int i;
		int used = 0;
		for (i = 0; i < li->n_syms; i++) {
			if (li->ls[i] && li->ls[i]->used) used = 1;
			else li->ls[i] = NULL;
		}
		if (!used && !(li->flags & LIB_LAZY)) {
			lii = LIST_STRUCT(li->e.prev, struct lib_int, e);
			DEL_FROM_LIST(&li->e);
			li = lii;
		}
	}

	has_com = 0;
	LIST_FOR_EACH(ls, &common_symbols, struct link_symbol, ce) {
		struct link_symbol *lls;
		if ((lls = lookup_symbol(global_symbol_hash, ls->name))) ls->shadow = lls;
		else has_com = 1;
	}
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(ls, &global_symbol_hash[i], struct link_symbol, e) {
		ls->ssect_off = ls->s ? ls->s->value : 0;
	}

	bss_proc = 0;
	sal = 1;
	LIST_FOR_EACH_BACK(s, &spad_sections, struct spad_section, e) {
		int sal1 = sal;
		struct spad_subsection *ss;
		__f_off off = 0;
		for (i = 0; i < s->n_link_sections; i++) {
			int j;
			char *special_sym[2] = { NULL, NULL };
			int special_align = 1;
			__f_off off1 = (__f_off)-1;
			if (!strcasecmp(s->link_sections[i], ".CTORS")) {
				special_sym[0] = "DLL$CTORS";
				special_sym[1] = "DLL$CTORS_END";
				special_align = sizeof(__f_off);
			} else if (!strcasecmp(s->link_sections[i], ".DTORS")) {
				special_sym[0] = "DLL$DTORS";
				special_sym[1] = "DLL$DTORS_END";
				special_align = sizeof(__f_off);
			} else if (!strcasecmp(s->link_sections[i], ".FEATURE_FIXUP")) {
				special_sym[0] = "DLL$FIXUP";
				special_sym[1] = "DLL$FIXUP_END";
				special_align = sizeof(__f_off);
			} else if (!strcasecmp(s->link_sections[i], ".EH_FRAME")) {
				special_sym[0] = "DLL$EFS";
				special_sym[1] = "DLL$EFE";
				special_align = sizeof(__f_off);
			}
			LIST_FOR_EACH(ss, &s->secs[i], struct spad_subsection, e) {
				if (ss->align < special_align) ss->align = special_align;
				special_align = 1;
				off = align_offset(off, ss->align);
				if (off1 == (__f_off)-1) off1 = off;
				ss->offset = off;
				off += ss->size;
				if (ss->align > sal) sal = ss->align;
				ss->sect_sym.sect = ss;
				ss->sect_sym.ssect = s;
				ss->sect_sym.ssect_off = ss->offset;
			}
			if (special_sym[0] && !LIST_EMPTY(&s->secs[i])) for (j = 0; j < 2; j++) {
				struct link_symbol *ls;
				if (resolve_name(special_sym[j])) {
					fprintf(stderr, "duplicate special symbol: `%s'\n", special_sym[j]);
					return -1;
				}

				ls = x_malloc(sizeof(struct link_symbol) + strlen(special_sym[j]) + 1);
				ls->s = NULL;
				ls->sect = LIST_STRUCT(s->secs[i].next, struct spad_subsection, e);
				ls->ssect = s;
				ls->exported = 0;
				strcpy(ls->name, special_sym[j]);
				ls->ssect_off = !j ? 0 : off - off1;
				insert_symbol(global_symbol_hash, ls);
			}
		}
		if (!strcasecmp(s->name, ".BSS")) {
			if (!bss_proc) LIST_FOR_EACH(ls, &common_symbols, struct link_symbol, ce) {
				if (!ls->shadow) {
					int al;
					ls->ssect = s;
					al = common_align(ls);
					off = align_offset(off, al);
					ls->ssect_off = off;
					off += ls->com_size;
					if (al > sal) sal = al;
				}
			}
			bss_proc = 1;
		}
		off = align_offset(off, sal1);
		if (!strcasecmp(s->name, ".RODATA") && sal < RODATA_SECTION_ALIGN) sal = RODATA_SECTION_ALIGN;
		s->align = sal;
		s->size = off;
	}
	
	if (!bss_proc && has_com) {
		fprintf(stderr, "no `.bss' section\n");
		return -1;
	}
	
	total_symbols = 0;
	special_symbols = 0;
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(ls, &global_symbol_hash[i], struct link_symbol, e) {
		ls->ssect_off += ls->sect->offset;
		total_symbols++;
		if (is_special(ls->name)) special_symbols++;
	}
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(ls, &common_symbol_hash[i], struct link_symbol, e) {
		if (ls->shadow) {
			ls->ssect = ls->shadow->ssect;
			ls->ssect_off = ls->shadow->ssect_off;
		} else {
			total_symbols++;
			if (is_special(ls->name)) special_symbols++;
		}
	}
	return 0;
}

#define header	((struct link_header *)output_header)

static int sym_comp(const void *s1_, const void *s2_)
{
	struct link_symbol *s1 = *(struct link_symbol **)s1_;
	struct link_symbol *s2 = *(struct link_symbol **)s2_;
	if (s1->exported && !s2->exported) return -1;
	if (!s1->exported && s2->exported) return 1;
	if (is_special(s1->name) && !is_special(s2->name)) return -1;
	if (!is_special(s1->name) && is_special(s2->name)) return 1;
	return strcmp(s1->name, s2->name);
}

static int sym_out_comp(const void *s1_, const void *s2_)
{
	struct link_symbol *s1 = *(struct link_symbol **)s1_;
	struct link_symbol *s2 = *(struct link_symbol **)s2_;
	if ((unsigned)s1->ssect->num < (unsigned)s2->ssect->num) return -1;
	if ((unsigned)s1->ssect->num > (unsigned)s2->ssect->num) return 1;
	if (s1->ssect_off < s2->ssect_off) return -1;
	if (s1->ssect_off > s2->ssect_off) return 1;
	return strcmp(s1->name, s2->name);
}

static long hard_write(int h, char *data, long len)
{
	long w;
	if (!len) return 0;
	do {
		w = write(h, data, len);
		if (w < 0) {
			perror("write");
			return -1;
		}
		if (!w) {
			fprintf(stderr, "write returned 0\n");
			return -1;
		}
		data += w;
	} while (len -=w);
	return 0;
}

static union {
	MD5_CTX md5_ctx;
	SHA_CTX sha_ctx;
	RIPEMD160_CTX ripemd160_ctx;
	SHA256_CTX sha256_ctx;
} hash_u;

static unsigned hash_type = LINK_HASH_SHA1;

static int set_hash(char *name)
{
	if (!strcasecmp(name, "none")) hash_type = LINK_HASH_NONE;
	else if (!strcasecmp(name, "md5")) hash_type = LINK_HASH_MD5;
	else if (!strcasecmp(name, "sha1")) hash_type = LINK_HASH_SHA1;
	else if (!strcasecmp(name, "ripemd160")) hash_type = LINK_HASH_RIPEMD160;
	else if (!strcasecmp(name, "sha256")) hash_type = LINK_HASH_SHA256;
	else return -1;
	return 0;
}

static void init_hash(void)
{
	switch (hash_type) {
		case LINK_HASH_NONE:
			break;
		case LINK_HASH_MD5:
			MD5Init(&hash_u.md5_ctx);
			break;
		case LINK_HASH_SHA1:
			SHA1_Init(&hash_u.sha_ctx);
			break;
		case LINK_HASH_RIPEMD160:
			RIPEMD160_Init(&hash_u.ripemd160_ctx);
			break;
		case LINK_HASH_SHA256:
			SHA256_Init(&hash_u.sha256_ctx);
			break;
		default:	
			fprintf(stderr, "internal error: unknown hash %x\n", hash_type);
			abort();
	}
}

static void add_hash(void *ptr, __f_off len)
{
	/*write(1, ptr, len);*/
	switch (hash_type) {
		case LINK_HASH_NONE:
			break;
		case LINK_HASH_MD5:
			MD5Update(&hash_u.md5_ctx, ptr, len);
			break;
		case LINK_HASH_SHA1:
			SHA1_Update(&hash_u.sha_ctx, ptr, len);
			break;
		case LINK_HASH_RIPEMD160:
			RIPEMD160_Update(&hash_u.ripemd160_ctx, ptr, len);
			break;
		case LINK_HASH_SHA256:
			SHA256_Update(&hash_u.sha256_ctx, ptr, len);
			break;
		default:	
			fprintf(stderr, "internal error: unknown hash %x\n", hash_type);
			abort();
	}
}

static void get_hash(__u8 *bytes)
{
	switch (hash_type) {
		case LINK_HASH_NONE:
			break;
		case LINK_HASH_MD5:
			MD5Final(bytes, &hash_u.md5_ctx);
			break;
		case LINK_HASH_SHA1:
			SHA1_Final(bytes, &hash_u.sha_ctx);
			break;
		case LINK_HASH_RIPEMD160:
			RIPEMD160_Final(bytes, &hash_u.ripemd160_ctx);
			break;
		case LINK_HASH_SHA256:
			SHA256_Final(bytes, &hash_u.sha256_ctx);
			break;
		default:	
			fprintf(stderr, "internal error: unknown hash %x\n", hash_type);
			abort();
	}
}

struct reloc_internal {
	__f_off pos;
	unsigned section;
	unsigned type;
} *relocs = NULL;
unsigned long n_relocs;

static void init_relocs(void)
{
	if (relocs) {
		fprintf(stderr, "internal error: relocs not freed\n");
		abort();
	}
	relocs = x_malloc(0);
	n_relocs = 0;
}

static void add_reloc(__f_off pos, unsigned section, unsigned type)
{
	relocs = x_srealloc(relocs, (n_relocs + 1), (sizeof(struct reloc_internal)));
	relocs[n_relocs].pos = pos;
	relocs[n_relocs].section = section;
	relocs[n_relocs].type = type;
	n_relocs++;
}

static int reloc_compare(const void *v1, const void *v2)
{
	const struct reloc_internal *r1 = v1;
	const struct reloc_internal *r2 = v2;
	if (r1->section != r2->section) return (int)(r1->section - r2->section);
	if (r1->type != r2->type) return (int)(r1->type - r2->type);
	if (r1->pos < r2->pos) return -1;
	if (r1->pos > r2->pos) return 1;
	return 0;
}

static void write_relocs(void)
{
	__u8 data[9];
	unsigned long n;
	__f_off pos = 0;
	unsigned type = REL_DEFAULT_TYPE;
	unsigned section = REL_DEFAULT_SECTION;
	qsort(relocs, n_relocs, sizeof(struct reloc_internal), reloc_compare);
	for (n = 0; n < n_relocs; n++) {
		__f_off diff;
		struct reloc_internal *r = &relocs[n];
		if (r->section != section || r->type != type) {
			pos = 0;
			section = r->section;
			type = r->type;
			data[0] = REL_SPECIAL | REL_SPECIAL_TYPE_SECTION | type;
			data[1] = section;
			write_header(data, 2);
		}
		diff = r->pos - pos;
		if (diff < 0x100) {
			int rl;
			for (rl = 1; rl < 255 + REL_SPECIAL_RLE_REPEAT_MINUS_3 + 3; rl++) if (n + rl >= n_relocs || r[rl].section != section || r[rl].type != type || r[rl].pos - r[rl - 1].pos != diff) break;
			if (rl >= 3) {
				if (rl < REL_SPECIAL_RLE_REPEAT_MINUS_3 + 3) {
					data[0] = REL_SPECIAL | REL_SPECIAL_RLE | (rl - 3);
					data[1] = diff;
					write_header(data, 2);
				} else {
					data[0] = REL_SPECIAL | REL_SPECIAL_RLE | REL_SPECIAL_RLE_REPEAT_MINUS_3;
					data[1] = diff;
					data[2] = rl - (REL_SPECIAL_RLE_REPEAT_MINUS_3 + 3);
					write_header(data, 3);
				}
				n += rl - 1;
				r += rl - 1;
			} else if (diff < REL_SPECIAL) {
				data[0] = diff;
				write_header(data, 1);
			} else {
				goto encode_long1;
			}
		} else if (diff < REL_SPECIAL_LONG1_VAL * 0x100) {
			encode_long1:
			data[0] = REL_SPECIAL | REL_SPECIAL_LONG1 | (diff >> 8);
			data[1] = diff;
			write_header(data, 2);
		} else {
			unsigned i, j;
			for (i = 1; diff >> (i * 8 - 8) >> 8; i++) ;
			if (i - 1 > REL_SPECIAL_LONG2_BYTES_MINUS_1) {
				fprintf(stderr, "internal error: too long number: %d bytes\n", i);
				abort();
			}
			data[0] = REL_SPECIAL | REL_SPECIAL_LONG2 | (i - 1);
			for (j = 0; j < i; j++) data[j + 1] = diff >> ((i - j - 1) * 8);
			write_header(data, i + 1);
		}
		pos = r->pos;
	}
	free(relocs);
	relocs = NULL;
	data[0] = REL_SPECIAL | REL_SPECIAL_TYPE_SECTION | REL_SPECIAL_TYPE_END;
	write_header(data, 1);
}

static int make_header(void)
{
	int n;
	int i, j, k;
	long l;
	int hrand;
	int written_syms;
	struct link_symbol **syms;
	struct spad_section *s;
	struct link_symbol *ls;
	struct lib_int *li;
	struct link_header lh;
	struct section sec;
	memset(&lh, 0, sizeof lh);
	strncpy((char *)&lh.lnk_id, "TMP", sizeof lh.lnk_id);
	lh.lnk_ver = LNK_VER;
	lh.mach_id = MACH_CURRENT;
	lh.mach_flags = 0;
	lh.flags = link_flags | hash_type;
	if (hash_type == LINK_HASH_NONE) goto skip_random;
	hrand = open("/dev/urandom", O_RDONLY);
	if (hrand == -1) {
#ifdef __SPAD__
		fprintf(stderr, "could not open /dev/urandom\n");
		return -1;
#endif
	} else {
		if (read(hrand, lh.hash_stir, LINK_HASH_STIR_LENGTH) != LINK_HASH_STIR_LENGTH) {
#ifdef __SPAD__
			fprintf(stderr, "could not read /dev/urandom\n");
			close(hrand);
			return -1;
#endif
		}
		close(hrand);
	}
	skip_random:
	i = 1;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) s->num = i++;
	if (i >= 255) {
		fprintf(stderr, "more than 255 sections (%d)\n", i);
		return -1;
	}
	lh.n_sections = i;
	write_header(&lh, sizeof(struct link_header));

	/* write out interface name */
	header->lib_name = output_len;
	write_header(out_interface->name, strlen(out_interface->name) + 1);

	/* write in interfaces */
	align_header();
	header->libs = output_len;
	header->n_libs = 0;
	LIST_FOR_EACH(li, &interfaces, struct lib_int, e) {
		struct library lib;
		memset(&lib, 0, sizeof lib);
		lib.flags = li->flags;
		write_header(&lib, sizeof lib);
		header->n_libs++;
	}

	/* write in interface names */
	i = 0;
	LIST_FOR_EACH(li, &interfaces, struct lib_int, e) {
		((struct library *)(output_header + header->libs))[i].lib_name = output_len;
		write_header(li->name, strlen(li->name) + 1);
		i++;
	}

	/* write sections */
	align_header();
	header->sections = output_len;
	memset(&sec, 0, sizeof sec);
	for (i = 0; i < lh.n_sections; i++) {
		write_header(&sec, sizeof(struct section));
	}

	header->compression_offset = output_len;

	/* write section names */
	s = LIST_STRUCT(spad_sections.next, struct spad_section, e);
	for (i = 0; i < lh.n_sections; i++) {
		char *str;
		if (!i) str = ".HEAD";
		else {
			str = s->name;
			s = LIST_STRUCT(s->e.next, struct spad_section, e);
		}
		((struct section *)(output_header + header->sections))[i].name = output_len;
		write_header(str, strlen(str) + 1);
	}

	/* write symbols */
	written_syms = link_flags & LINK_STRIPPED ? out_interface->n_syms + special_symbols : total_symbols;
	align_header();
	header->syms = output_len;
	header->n_exported_syms = out_interface->n_syms;
	header->n_special_syms = special_symbols;
	header->n_syms = written_syms;

	syms = x_salloc(total_symbols, sizeof(struct link_symbol *));

	n = 0;
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(ls, &global_symbol_hash[i], struct link_symbol, e) {
		syms[n++] = ls;
	}
	for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(ls, &common_symbol_hash[i], struct link_symbol, e) {
		if (!ls->shadow) syms[n++] = ls;
	}
	if (n != total_symbols) {
		fprintf(stderr, "internal error: symbol count doesn not match: %d != %d\n", total_symbols, n);
		abort();
	}
	qsort(syms, total_symbols, sizeof(struct link_symbol *), sym_comp);
	for (i = 0; i < written_syms; i++) {
		struct sym sym;
		sym.name = 0;
		sym.value = syms[i]->ssect_off;
		write_header(&sym, sizeof sym);
	}
	for (i = 0; i < written_syms; i++) {
		__u8 sec = syms[i]->ssect->num;
		write_header(&sec, 1);
		((struct sym *)(output_header + header->syms))[i].name = output_len;
		write_header(syms[i]->name, strlen(syms[i]->name) + 1);
	}

	/* write relocations against .HEAD */
	{
		init_relocs();
		((struct section *)(output_header + header->sections))[0].relocs.rel = output_len;
		write_relocs();
	}

	/* write relocations against other sections */
	i = 0;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		struct patch *p;
		i++;
		init_relocs();
		((struct section *)(output_header + header->sections))[i].relocs.rel = output_len;

		LIST_FOR_EACH(p, &patches, struct patch, e) {
			if (p->howto_pcrel_offset == REL_PC && p->sec->s == s) {
				if (p->symbol->ssect == s) continue;
				add_reloc(p->sec->offset + p->address, p->sec->s->num, REL_SPECIAL_TYPE_SUB);
				continue;
			}
			if (p->howto_pcrel_offset == REL_GOT && got.s == s) {
				if (p->symbol->ssect == s) continue;
				add_reloc(p->sec->offset + p->address, p->sec->s->num, REL_SPECIAL_TYPE_SUB);
				continue;
			}
			if (p->symbol->ssect == s) {
				add_reloc(p->sec->offset + p->address, p->sec->s->num, REL_SPECIAL_TYPE_ADD);
				continue;
			}
		}
		write_relocs();
	}

	/* write in interfaces */
	i = 0;
	LIST_FOR_EACH(li, &interfaces, struct lib_int, e) {
		long symstart;
		align_header();
		symstart = output_len;
		((struct library *)(output_header + header->libs))[i].syms = output_len;
		for (j = 0, k = 0; j < li->n_syms; j++) if (li->ls[j]) {
			struct lib_sym lib_sym;
			memset(&lib_sym, 0, sizeof lib_sym);
			/*lib_sym.hint_idx = li->ls[j]->interface_index;*/
			write_header(&lib_sym, sizeof lib_sym);
			k++;
		}
		((struct library *)(output_header + header->libs))[i].n_syms = k;
		for (j = 0, k = 0; j < li->n_syms; j++) if (li->ls[j]) {
			((struct lib_sym *)(output_header + symstart))[k].name = output_len;
			write_header(li->syms[j], strlen(li->syms[j]) + 1);
			k++;
		}
		for (j = 0, k = 0; j < li->n_syms; j++) if (li->ls[j]) {
			struct patch *p;
			init_relocs();
			((struct lib_sym *)(output_header + symstart))[k].reloc.rel = output_len;
			LIST_FOR_EACH(p, &patches, struct patch, e) if (p->symbol->interface == li && p->symbol->interface_index == j) {
				add_reloc(p->sec->offset + p->address, p->sec->s->num, REL_SPECIAL_TYPE_ADD);
			}
			write_relocs();
			k++;
		}
		i++;
	}

	l = align_offset(output_len, LIST_STRUCT(spad_sections.next, struct spad_section, e)->align);
	while (output_len < l) {
		char c = 0;
		write_header(&c, 1);
	}

	/* compute sections offsets and sizes */
	{
		struct section *x = &((struct section *)(output_header + header->sections))[0];
		x->offset = 0;
		x->len = l;
		x->relocs.last_val = x->offset + reloc;
		x->ptr = x->relocs.last_val;
	}
	i = 0;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		struct section *x = &((struct section *)(output_header + header->sections))[++i];
		s->offset = l;
		x->offset = l;
		x->len = s->size;
		if (i <= SECTION_BSS) {
			x->relocs.last_val = x->offset + reloc;
			x->ptr = x->relocs.last_val;
		}
		s->address = x->relocs.last_val;
		if (i != SECTION_BSS) {
			l += s->size;
		}
		if (i == SECTION_DATA) {
			header->compressed_file_size = l;
		}
	}

	/* set jump symbols */
	for (i = 0; i < n_jmp_symbols; i++) {
		ls = resolve_name(jmp_symbols[i]);
		if (!ls) {
			fprintf(stderr, "could not find jump symbol `%s'\n", jmp_symbols[i]);
			return -1;
		}
		SET_JMP(header, i, ls->ssect_off + ls->ssect->offset);
	}

	/* write symfile */
	if (symfile) {
		FILE *f;
		qsort(syms, total_symbols, sizeof(struct link_symbol *), sym_out_comp);
		if (!(f = fopen(symfile, "w"))) {
			unlink(symfile);
			if (!(f = fopen(symfile, "w"))) {
				perror(symfile);
				return -1;
			}
		}
		for (i = 0; i < total_symbols; i++) {
			fprintf(f, "%-7s %0*lX %s\n", syms[i]->ssect->name, (int)sizeof(long) * 2, (long)syms[i]->ssect_off + syms[i]->ssect->offset, syms[i]->name);
		}
		fclose(f);
	}
	free(syms);

	/* write .HEAD section physically */
	if (hard_write(out_handle, output_header, output_len)) return 1;

	/* compute hash of .HEAD */
	lh.lnk_id = LNK_ID;
	add_hash(&lh, sizeof lh.lnk_id);
	add_hash(output_header + sizeof lh.lnk_id, __offsetof(struct link_header, hash) - sizeof lh.lnk_id);
	add_hash(output_header + __offsetof(struct link_header, hash) + sizeof(lh.hash), output_len - __offsetof(struct link_header, hash) - sizeof(lh.hash));

	free(output_header);

	return 0;
}

static int write_pad(__f_off pad)
{
	char zero[256];
	memset(zero, 0, sizeof zero);
	while (pad) {
		unsigned len = pad > 256 ? 256 : pad;
		add_hash(zero, len);
		if (hard_write(out_handle, zero, len)) return -1;
		pad -= len;
	}
	return 0;
}

static int write_sections(void)
{
	struct spad_section *s;
	__f_off pos = LIST_STRUCT(spad_sections.next, struct spad_section, e)->offset;
	LIST_FOR_EACH(s, &spad_sections, struct spad_section, e) {
		__f_off subpos;
		int i;
		struct spad_subsection *ss;
		if (!strcasecmp(s->name, ".BSS")) continue;
		if (pos < s->offset) {
			if (write_pad(s->offset - pos) < 0) return -1;
			pos = s->offset;
		}
		subpos = 0;
		for (i = 0; i < s->n_link_sections; i++) LIST_FOR_EACH(ss, &s->secs[i], struct spad_subsection, e) {
			struct patch *p;
			asection *sect = ss->sect;
			char *ptr;
			if (ss == &got) {
				ptr = ss->contents;
			} else {
				ptr = x_malloc(ss->size);
				if (!bfd_get_section_contents(sect->owner, sect, ptr, 0, ss->size)) {
					bfd_perror("bfd_get_section_contents");
					return -1;
				}
			}
			LIST_FOR_EACH(p, &patches, struct patch, e) if (p->sec == ss) {
				__f_off add;
				if (p->address + sizeof(__f_off) > ss->size) {
					fprintf(stderr, "patch out of data\n");
					return -1;
				}
				add = 0;
				if (p->howto_pcrel_offset == REL_PC) {
					add = -(p->address + ss->offset + ss->s->address);
				} else if (p->howto_pcrel_offset == REL_GOT) {
					add = -(got.offset + got.s->address);
				}
				if (!p->symbol->interface) {
					if (!p->symbol->ssect) {
						fprintf(stderr, "internal error: no section on symbol `%s'\n", p->symbol->name);
						abort();
					}
					add += p->symbol->ssect->address;
				}
				add += p->symbol->ssect_off + p->special_offset;
				*(__f_off *)(ptr + p->address) += add;
			}
			if (subpos < ss->offset) {
				if (write_pad(ss->offset - subpos) < 0) return -1;
				subpos = ss->offset;
			}
			add_hash(ptr, ss->size);
			if (hard_write(out_handle, ptr, ss->size)) return -1;
			subpos += ss->size;
			if (ss != &got) free(ptr);
		}
		if (subpos > s->size) {
			fprintf(stderr, "section overflow: %lu > %lu\n", (unsigned long)subpos, (unsigned long)s->size);
			abort();
		}
		if (write_pad(s->size - subpos) < 0) return -1;
		subpos = s->size;
		pos += subpos;
	}
	return 0;
}

static int update_header(void)
{
	struct link_header lh;
	if (lseek(out_handle, __offsetof(struct link_header, hash), SEEK_SET) < 0) {
		perror("lseek");
		return -1;
	}
	memset(&lh.hash, 0, sizeof lh.hash);
	get_hash(lh.hash);
	if (hard_write(out_handle, (char *)&lh.hash, sizeof lh.hash)) return -1;
	if (lseek(out_handle, 0, SEEK_SET) < 0) {
		perror("lseek");
		return -1;
	}
	lh.lnk_id = LNK_ID;
	if (hard_write(out_handle, (char *)&lh, sizeof lh.lnk_id)) return -1;
	return 0;
}

int main(int argc, char *argv[])
{
	int ff;
	int i;
	int sh;
	char *out_int, *outfile;
	char *out_int_rename;
	char out_int_create;
	char shared;
	bfd *bfdlist_start, *bfdlist_end, *b;

	char **lib;
	int lib_n;
	int *libs;
	int libs_n;
	char **liblazy;
	int liblazy_n;
	int allow_unresolved;

	char *jmp_string = NULL;

	char **relocargs;
	int n_relocargs;

	int static_;
	int tx, ro, dt, bs;

	bfd_init();

	if (argc < 2) {
		bad_param:
		fprintf(stderr, "\
Usage: LINK\n\
	-stext <section name>,...		(default .text,.text.end)\n\
	-srodata <section name>,...		(default .rodata)\n\
	-sdata <section name>,...		(default .data)\n\
	-sbss <section name>,...		(default .bss)\n\
	-sother <section name>,...		(default nothing)\n\
	-o <output spad file>			(default A.EXE or A.DLL)\n\
	-L <library directory>			directory for .INT and .A files\n\
	-l <library interface file>		link with .INT or .A library\n\
	-m <library interface file>		.INT library for lazy link\n\
	-shared					make a library without inteface\n\
	-D <library description file>		write out interface\n\
	-d <library description file>		out interface\n\
	-device					out interface is DEVICE\n\
	-h <interface name>			override out interface name\n\
	-share					(default when -d or -device)\n\
	-multiple				(default without -d)\n\
	-reloc <hex address>			(default 0)\n\
	-jmp <symbols>				(default none)\n\
	-Bstatic				prefer .A over .INT\n\
	-Bdynamic				(default)\n\
	-s					do not include symbols\n\
	-unresolved				treat unresolved symbols as 0\n\
	-y <output symbol file>			(default no file)\n\
	-chash <none,md5,sha1,ripemd160,sha256>	(default sha1)\n\
	-b <format>				(default elf32-i386)\n\
	-r					call ld to do incremental link\n\
	<input elf file or archive>		file to link\n\
");
		return 3;
	}
	force_dynamic = getenv("LINK_FORCE_DYNAMIC");
	link_init();
	ff = 0;
	sh = -1;
	out_int = NULL;
	out_int_create = 0;
	shared = 0;
	outfile = NULL;
	out_int_rename = NULL;
	symfile = NULL;
	bfdlist_start = bfdlist_end = NULL;
	lib = NULL;
	lib_n = 0;
	libs = NULL;
	libs_n = 0;
	liblazy = NULL;
	liblazy_n = 0;
	allow_unresolved = 0;
	relocargs = NULL;
	n_relocargs = 2;
	static_ = 0;
	tx = ro = dt = bs = 1;
	for (i = 1; i < argc; i++) {
		if (!ff && argv[i][0] == '-') {
			if (!strcmp(argv[i], "--")) ff = 1;
			else if (!strcmp(argv[i], "-r")) {
				execvp("ld", argv);
				perror("exec ld");
				return 1;
			}
			else if (!strcmp(argv[i], "-share")) sh = 1;
			else if (!strcmp(argv[i], "-multiple")) sh = 0;
			else if (!strcmp(argv[i], "-strip") || !strcmp(argv[i], "-s")) link_flags |= LINK_STRIPPED;
			else if (!strcmp(argv[i], "-unresolved")) allow_unresolved = allow_unresolved ? 2 : 1;
			else if (!strcmp(argv[i], "-shared")) {
				if (shared) goto bad_param;
				shared = 1;
			} else if (!strcmp(argv[i], "-device")) {
				if (out_int) goto bad_param;
				out_int = (char *)1;
			} else if (!strcmp(argv[i], "-reloc")) {
				char *e;
				if (i == argc - 1) goto bad_param;
				reloc = strtoul(argv[++i], &e, 16);
				if (*e) goto bad_param;
			} else if (!strcmp(argv[i], "-jmp")) {
				if (jmp_string) goto bad_param;
				if (i == argc - 1) goto bad_param;
				jmp_string = argv[++i];
			} else if (!strcmp(argv[i], "-chash")) {
				if (i == argc - 1) goto bad_param;
				if (set_hash(argv[++i])) goto bad_param;
			} else {
				char *p;
				char c;
				if (!(c = argv[i][1])) goto bad_param;
				if (!argv[i][2]) {
					if (i == argc - 1) goto bad_param;
					p = argv[++i];
				} else p = &argv[i][2];
				if (c == 's') {
					char *a, *aa, *as;
					if (i++ == argc - 1) goto bad_param;
					a = argv[i];
					next:
					if (!(as = strchr(a, ','))) aa = a;
					else {
						aa = x_malloc(as - a + 1);
						memcpy(aa, a, as - a);
						aa[as - a] = 0;
						a = as + 1;
					}
					if (!*aa) {
						free(aa);
						goto bad_param;
					}
					if (!strcmp(p, "other")) {
						if (add_section(aa, aa)) goto bad_param;
					} else if (!strcmp(p, "text")) {
						if (!tx) goto bad_param;
						if (strcasecmp(aa, "no")) {
							if (add_subsection(".text", aa)) goto bad_param;
						} else tx = 0;
					} else if (!strcmp(p, "rodata")) {
						if (!ro) goto bad_param;
						if (strcasecmp(aa, "no")) {
							if (add_subsection(".rodata", aa)) goto bad_param;
						} else ro = 0;
					} else if (!strcmp(p, "data")) {
						if (!dt) goto bad_param;
						if (strcasecmp(aa, "no")) {
							if (add_subsection(".data", aa)) goto bad_param;
						} else dt = 0;
					} else if (!strcmp(p, "bss")) {
						if (!bs) goto bad_param;
						if (strcasecmp(aa, "no")) {
							if (add_subsection(".bss", aa)) goto bad_param;
						} else bs = 0;
					} else goto bad_param;
					if (aa != a) {
						free(aa);
						goto next;
					}
				} else if (c == 'o') {
					if (outfile) goto bad_param;
					outfile = p;
				} else if (c == 'L') {
					addstr(&libpath, &libpath_n, p, 0);
				} else if (c == 'l') {
					int x;
					for (x = 0; x < lib_n; x++) if (!strcmp(lib[x], p)) goto skip;
					addstr(&lib, &lib_n, p, 0);
					addint(&libs, &libs_n, static_);
					skip:;
				} else if (c == 'm') {
					addstr(&liblazy, &liblazy_n, p, 0);
				} else if (c == 'd') {
					if (out_int) goto bad_param;
					out_int = p;
				} else if (c == 'D') {
					if (out_int) goto bad_param;
					out_int = p;
					out_int_create = 1;
				} else if (c == 'h') {
					size_t l;
					if (out_int_rename) goto bad_param;
					out_int_rename = x_malloc((l = strlen(p)) + 1);
					strcpy(out_int_rename, p);
					upcase(out_int_rename);
					if (l > 4 && !strcmp(out_int_rename + l - 4, ".DLL")) out_int_rename[l - 4] = 0;
					else if (l > 4 && !strcmp(out_int_rename + l - 4, ".INT")) out_int_rename[l - 4] = 0;
					else if (l > 3 && !strcmp(out_int_rename + l - 3, ".SO")) out_int_rename[l - 3] = 0;
				} else if (c == 'b') {
					bfdformat = p;
				} else if (c == 'y') {
					if (symfile) goto bad_param;
					symfile = p;
				} else if (c == 'B') {
					if (!strcmp(p, "static")) static_ = 1;
					else if (!strcmp(p, "dynamic")) static_ = 0;
					else goto bad_param;
				} else goto bad_param;
			}
		} else {
			char *name = argv[i];
			int type = guess_type(name, 0);
			bfd *b = bfd_openr(name, bfdformat);
			if (!b) {
				goto bfd_perr;
			}
			if (bfd_check_format(b, bfd_archive)) {
				add_archive(name, b, 0);
			} else if (bfd_check_format(b, bfd_object)) {
				if (bfdlist_end) {
					bfdlist_end->usrdata = b;
					bfdlist_end = b;
					b->usrdata = NULL;
				} else (bfdlist_start = bfdlist_end = b)->usrdata = NULL;
			} else {
				bfd_perr:
				if (type == 0 || type == 1) {
					if (!strpbrk(name, ":/")) {
						char *n = x_malloc(strlen(name) + 3);
						strcpy(n, "./");
						strcat(n, name);
						name = n;
					}
					addstr(&lib, &lib_n, name, 0);
					addint(&libs, &libs_n, 0);
				} else {
					bfd_perror(name);
					return 1;
				}
			}
		}
	}
	if (shared && !out_int) {
		out_int = "/dev/null";
		out_int_create = 1;
	}
	if (jmp_string) next_jmp_sym: {
		size_t l = strcspn(jmp_string, ",");
		char *p = x_malloc(l + 1);
		memcpy(p, jmp_string, l);
		p[l] = 0;
		addstr(&jmp_symbols, &n_jmp_symbols, p, 0);
		jmp_string += l;
		if (*jmp_string) {
			jmp_string++;
			goto next_jmp_sym;
		}
	}
	if (n_jmp_symbols > MAX_JMP_SYMBOLS) {
		fprintf(stderr, "too many jump symbols: %d > %d\n", n_jmp_symbols, MAX_JMP_SYMBOLS);
		return 1;
	}
	if (sh == -1) sh = !out_int || out_int == (char *)1 ? 0 : 1;
	if (!out_int) {
		out_interface = &default_out_interface;
	} else if (out_int == (char *)1) {
		out_interface = &dev_out_interface;
	} else if (out_int_create) {
		struct stat st;
		char is_dev;
		out_interface = &empty_out_interface;
		out_interface->name = filename_base(out_int, 0);
		is_dev = !stat(out_int, &st) && !S_ISREG(st.st_mode);
		if ((!*out_interface->name || is_dev) && outfile) {
			free(out_interface->name);
			out_interface->name = filename_base(outfile, 0);
		}
		upcase(out_interface->name);
	} else if (!(out_interface = load_interface(out_int, 0, 0, 1))) {
		fprintf(stderr, "interface `%s' not found\n", out_int);
		return 1;
	}
	if (out_int_rename) out_interface->name = out_int_rename;

	if (!outfile) outfile = !out_int ? "A.EXE" : out_int == (char *)1 ? "A.SYS" : "A.DLL";

	add_default_subsections(tx, ro, dt, bs);

	/* This must be before generic libraries
	   --- otherwise it breaks the build of Lesstif */
	for (i = 0; i < n_archives; i++) if (!archive_l[i]) {
		char *str;
		size_t len;
		if (is_forced_dynamic(archive_filenames[i], &str, &len)) {
			int r;
			char *p = x_malloc(len + 1);
			memcpy(p, str, len);
			p[len] = 0;
			r = load_library(p, -2);
			if (r == -2) return 1;
			if (!r) archive_l[i] = -1;
			free(p);
		}
	}
	for (i = 0; i < lib_n; i++) {
		if (load_library(lib[i], libs[i])) {
			return 1;
		}
	}
	for (i = 0; i < liblazy_n; i++) {
		if (load_library(liblazy[i], -1)) {
			return 1;
		}
	}

	if (sh) link_flags |= LINK_SHARED;

	prepare_sections();
	for (b = bfdlist_start; b; b = b->usrdata) {
		if (load_object(b, (char *)b->filename, 0)) return 1;
	}

	if (out_int_create) {
		int h;
		struct link_symbol *s;
		search_archives(1);
		for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(s, &global_symbol_hash[i], struct link_symbol, e) export_symbol(s);
		for (i = 0; i < SYMBOL_HASH_SIZE; i++) XLIST_FOR_EACH(s, &common_symbol_hash[i], struct link_symbol, e) export_symbol(s);
		qsort(out_interface->syms, out_interface->n_syms, sizeof(char *), compare_string);
		for (i = 0; i < out_interface->n_syms; i++) {
			if (strlen(out_interface->syms[i]) >= LINK_DYNAMIC_SYMBOL_NAME_LEN) {
				fprintf(stderr, "too long exported symbol name `%s'\n", out_interface->syms[i]);
				return 1;
			}
		}
		if ((h = creat(out_int, 0644)) == -1) {
			unlink(out_int);
			if ((h = creat(out_int, 0644)) == -1) {
				perror(out_int);
				return 1;
			}
		}
		for (i = 0; i < out_interface->n_syms; i++) {
			if (hard_write(h, out_interface->syms[i], strlen(out_interface->syms[i]))) return 1;
			if (hard_write(h, "\n", 1)) return 1;
		}
		close(h);
	}
	try_again:
	if (out_syms) free(out_syms);
	out_syms = x_malloc(out_interface->n_syms * sizeof(struct link_symbol *));
	memset(out_syms, 0, out_interface->n_syms * sizeof(struct link_symbol *));
	if (resolve_patches()) return 1;
	if (unresolved_n) {
		int j, w;
		int s;
		if (squash_missing_out_syms()) goto try_again;
		s = search_archives(0);
		if (s > 0) goto try_again;
		if (s < 0) return 1;
		if (!are_there_unresolved()) goto ok;
		if (!allow_unresolved) fprintf(stderr, "undefined symbols: ");
		else if (allow_unresolved == 1) fprintf(stderr, "warning: undefined symbols: ");
		w = 0;
		for (i = 0; i < unresolved_n; i++) {
			for (j = 0; j < i; j++) if (!strcmp(unresolved[i], unresolved[j])) goto skipdup;
			if (resolve_name(unresolved[i])) continue;
			if (allow_unresolved < 2) {
				fprintf(stderr, "%s%s", w ? ", " : "", do_demangle(unresolved[i]));
				w = 1;
			}
			if (allow_unresolved) {
				struct link_symbol *ls = x_malloc(sizeof(struct link_symbol) + strlen(unresolved[i]) + 1);
				memset(ls, 0, sizeof(struct link_symbol));
				strcpy(ls->name, unresolved[i]);
				ls->sect = &spad_abs_subsection;
				ls->ssect = &spad_abs_section;
				insert_symbol(global_symbol_hash, ls);
			}
			skipdup:;
		}
		if (allow_unresolved < 2) fprintf(stderr, "\n");
		if (allow_unresolved) goto try_again;
		return 1;
	}
	ok:
	if (resolve_extern_patches()) return 1;

	if (prepare_output()) return 1;

	init_hash();

	if ((out_handle = creat(outfile, 0755)) == -1) {
		unlink(outfile);
		if ((out_handle = creat(outfile, 0755)) == -1) {
			perror(outfile);
			return 1;
		}
	}

	if (make_header()) {
		ret1:
		close(out_handle);
		unlink(outfile);
		return 1;
	}

	if (write_sections()) goto ret1;

	if (update_header()) goto ret1;

	close(out_handle);

	return 0;
}
