#include <ERRNO.H>
#include <STRING.H>
#include <STDLIB.H>
#include <VALUES.H>
#include <SPAD/LIBC.H>
#include <RESOLV.H>
#include <STDIO.H>

#include "SSHD.H"
#include "OPS.H"

#define KEY_FILE	"AUTH.:/AUTHORIZED_KEYS.DAT"

static char *get_line(FILE *f)
{
	char rbuf[1024];
	char *nl;
	__u8 *b;
	unsigned bl;
	init_str(&b, &bl);

	get_next:
	if (!fgets(rbuf, sizeof rbuf, f)) {
		if (!bl) {
			free(b);
			return NULL;
		}
		goto ret_b;
	}
	if (__likely((nl = strchr(rbuf, '\n')) != NULL)) {
		if (__unlikely(add_bytes_to_str(&b, &bl, (__u8 *)rbuf, nl - rbuf))) return NULL;
		ret_b:
		if (__unlikely(add_chr_to_str(&b, &bl, 0))) return NULL;
		return (char *)b;
	} else {
		if (__unlikely(add_str_to_str(&b, &bl, rbuf))) return NULL;
		goto get_next;
	}
}

static int find_key(const char *file, const char *key_type, const char *key_uu)
{
	int match = 0;
	char *l;
	FILE *f = fopen(file, "r");
	if (!f) return 1;
	while (!match && (l = get_line(f))) {
		char *s1 = strchr(l, ' '), *s2;
		if (__unlikely(!s1)) goto cont;
		*s1++ = 0;
		s2 = strchr(s1, ' ');
		if (__likely(s2 != NULL)) *s2 = 0;
		match = !strcmp(key_type, l) && !strcmp(key_uu, s1);
		cont:
		free(l);
	}
	fclose(f);
	return !match;
}

static int uudecode(const char *src, __u8 **dst, size_t *len)
{
	ssize_t l = _b64_nsize(strlen(src));
	if (__unlikely(l < 0))
		return -EMSGSIZE;
	*dst = malloc(l);
	if (__unlikely(!*dst))
		return -errno;
	l = b64_pton(src, *dst, l);
	if (__unlikely(l < 0))
		return -EBADSYN;
	*len = l;
	return 0;
}

int main(int argc, const char * const argv[])
{
	const struct public_type *type;

	__u8 *key = NULL, *data = NULL, *signature = NULL;
	size_t key_len = 0, data_len = 0, signature_len = 0;

	union p_key *p_key = NULL;

	int r;

	if (__unlikely(argc != 5))
		return -EBADSYN;

	type = get_public_type(argv[1]);
	if (__unlikely(!type))
		return 1;

	if (find_key(KEY_FILE, argv[1], argv[2]))
		return 1;

	if (__unlikely(r = uudecode(argv[2], &key, &key_len)) ||
	    __unlikely(r = uudecode(argv[3], &data, &data_len)) ||
	    __unlikely(r = uudecode(argv[4], &signature, &signature_len)))
		goto ret;

	/*{
		int i;
		for (i = 0; i < data_len; i++) __debug_printf("%c", data[i]);
	}*/

	p_key = type->load_public_from_blob(key, key_len);
	if (__unlikely(!p_key)) {
		r = -errno;
		goto ret;
	}

	r = type->verify(p_key, signature, signature_len, data, data_len);

	ret:
	if (p_key) type->destroy(p_key);
	free(key);
	free(data);
	free(signature);

	return r;
}
