#include <STDLIB.H>
#include <STRING.H>
#include <SPAD/LIBC.H>
#include <OPENSSL/BN.H>

#include "SSHD.H"
#include "OPS.H"

int bn_2_string(BIGNUM *bn, __u8 **buf, unsigned *bytes)
{
	if (__unlikely(bn->neg)) return -1;
	*bytes = BN_num_bytes(bn);
	if (__unlikely(!(*buf = malloc(*bytes + 1)))) return -1;
	if (__unlikely(BN_bn2bin(bn, *buf) != *bytes))
		KERNEL$SUICIDE("Wrong number of bytes put in bignum");
	if (__likely(*bytes) && (*buf)[0] >= 0x80) {
		memmove(*buf + 1, *buf, *bytes);
		(*buf)[0] = 0;
		(*bytes)++;
	}
	return 0;
}

int add_bn_to_str(__u8 **s, unsigned *l, BIGNUM *bn)
{
	__u8 *nn;
	unsigned n;
	if (__unlikely(bn_2_string(bn, &nn, &n))) {free(s); return -1;}
	if (__unlikely(add_len_str_to_str(s, l, nn, n))) {free(nn); return -1;}
	free(nn);
	return 0;
}

int get_bn_from_str(const __u8 *str, unsigned len, unsigned *ptr, BIGNUM *bn)
{
	const __u8 *data;
	unsigned datalen;
	if (__unlikely(get_len_str_from_str(str, len, ptr, &data, &datalen)))
		return 1;
	if (__unlikely(datalen > 8192))
		return -1;
	if (__likely(datalen) && __unlikely((__u8)data[0] >= 0x80))
		return -1;
	if (__unlikely(!BN_bin2bn(data, datalen, bn)))
		return -1;
	return 0;
}

