#include <STRING.H>
#include <OPENSSL/EVP.H>

#include "SSHD.H"

const struct cipher_type cipher_none = {
	8, 0, EVP_enc_null, "none"
};

static const struct cipher_type cipher_3des_cbc = {
	8, 24, EVP_des_ede3_cbc, "3des-cbc"
};

static const struct cipher_type cipher_blowfish_cbc = {
	8, 16, EVP_bf_cbc, "blowfish-cbc"
};

static const struct cipher_type cipher_cast128_cbc = {
	8, 16, EVP_cast5_cbc, "cast128-cbc"
};

static const struct cipher_type cipher_arcfour = {
	8, 16, EVP_rc4, "arcfour"
};

static const struct cipher_type cipher_aes128_cbc = {
	16, 16, EVP_aes_128_cbc, "aes128-cbc"
};

static const struct cipher_type cipher_aes192_cbc = {
	16, 24, EVP_aes_192_cbc, "aes192-cbc"
};

static const struct cipher_type cipher_aes256_cbc = {
	16, 32, EVP_aes_256_cbc, "aes256-cbc"
};

/*
static const struct cipher_type cipher_aes128_ctr = {
	16, 16, EVP_aes_128_ctr, "aes128-ctr"
};

static const struct cipher_type cipher_aes192_ctr = {
	16, 24, EVP_aes_192_ctr, "aes192-ctr"
};

static const struct cipher_type cipher_aes256_ctr = {
	16, 32, EVP_aes_256_ctr, "aes256-ctr"
};
*/

const struct cipher_type * const cipher_types[] = {
	&cipher_aes256_cbc,
	&cipher_aes192_cbc,
	&cipher_aes128_cbc,
	&cipher_cast128_cbc,
	&cipher_blowfish_cbc,
	&cipher_3des_cbc,
	&cipher_arcfour,
	&cipher_none,
	/*
	&cipher_aes128_ctr,
	&cipher_aes192_ctr,
	&cipher_aes256_ctr,
	*/
	NULL
};

int setup_in_cipher(struct ssh_connection *c, const struct cipher_type *ct, const __u8 *key, const __u8 *iv)
{
	const EVP_CIPHER *type = ct->evp_cipher();
	/*__debug_printf("in cipher: %s\n", ct->name);*/
	if (__unlikely(!type)) {
		debug_fatal(c, "NULL returned for cipher '%s'", ct->name);
		return -ENOENT;
	}
	EVP_CIPHER_CTX_cleanup(&c->in_cipher.evp_ctx);
	EVP_CIPHER_CTX_init(&c->in_cipher.evp_ctx);
	if (__unlikely(!EVP_DecryptInit(&c->in_cipher.evp_ctx, type, NULL, iv))) {
		debug_fatal(c, "EVP_DecryptInit failed with cipher '%s'", ct->name);
		return -EINVAL;
	}
	if (__unlikely(!EVP_CIPHER_CTX_set_key_length(&c->in_cipher.evp_ctx, ct->keysize))) {
		debug_fatal(c, "EVP_CIPHER_CTX_set_key_length failed with cipher '%s' and key length %d", ct->name, ct->keysize);
		return -EINVAL;
	}
	if (__unlikely(!EVP_DecryptInit(&c->in_cipher.evp_ctx, NULL, key, NULL))) {
		debug_fatal(c, "EVP_DecryptInit failed for key with cipher '%s'", ct->name);
		return -EINVAL;
	}
	c->in_cipher.type = ct;
	return 0;
}

int setup_out_cipher(struct ssh_connection *c, const struct cipher_type *ct, const __u8 *key, const __u8 *iv)
{
	const EVP_CIPHER *type = ct->evp_cipher();
	/*__debug_printf("out cipher: %s\n", ct->name);*/
	if (__unlikely(!type)) {
		debug_fatal(c, "NULL returned for cipher '%s'", ct->name);
		return -ENOENT;
	}
	EVP_CIPHER_CTX_cleanup(&c->out_cipher.evp_ctx);
	EVP_CIPHER_CTX_init(&c->out_cipher.evp_ctx);
	if (__unlikely(!EVP_EncryptInit(&c->out_cipher.evp_ctx, type, NULL, iv))) {
		debug_fatal(c, "EVP_EncryptInit failed with cipher '%s'", ct->name);
		return -EINVAL;
	}
	if (__unlikely(!EVP_CIPHER_CTX_set_key_length(&c->out_cipher.evp_ctx, ct->keysize))) {
		debug_fatal(c, "EVP_CIPHER_CTX_set_key_length failed with cipher '%s' and key length %d", ct->name, ct->keysize);
		return -EINVAL;
	}
	if (__unlikely(!EVP_EncryptInit(&c->out_cipher.evp_ctx, NULL, key, NULL))) {
		debug_fatal(c, "EVP_EncryptInit failed for key with cipher '%s'", ct->name);
		return -EINVAL;
	}
	c->out_cipher.type = ct;
	return 0;
}
