#include <STRING.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>

#include "SSHD.H"

static struct {
	char *name;
	char *file;
	union p_key *key;
} server_keys[] = {
	"ssh-rsa", "SSHD:/SSH_HOST_RSA_KEY", NULL,
	"ssh-dss", "SSHD:/SSH_HOST_DSA_KEY", NULL,
	NULL, NULL, NULL,
};

union p_key *sshd_get_server_key(const char *name)
{
	int i;
	for (i = 0; server_keys[i].name; i++)
		if (!strcmp(server_keys[i].name, name))
			return server_keys[i].key;
	return NULL;
}

int sshd_load_server_keys(void)
{
	int i;
	int got_something = 0;
	for (i = 0; server_keys[i].name; i++) {
		char error[__MAX_STR_LEN];
		const struct public_type *p = get_public_type(server_keys[i].name);
		if (!p) continue;
		server_keys[i].key = p->load_private_from_file(server_keys[i].file, error);
		if (!server_keys[i].key) {
			if (!*error) continue;
			strcpy(KERNEL$ERROR_MSG(), error);
			return -errno;
		}
		got_something = 1;
	}
	if (!got_something) {
		strcpy(KERNEL$ERROR_MSG(), "NO SERVER KEY AVAILABLE");
		return -ENOENT;
	}
	return 0;
}

